/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.rubycoder.gsm.GSMDecoder;
import org.rubycoder.gsm.GSMEncoder;
import org.rubycoder.gsm.InvalidGSMFrameException;

public class GSMDriver {
    private static void decode(String string, String string2) {
        GSMDecoder gSMDecoder = new GSMDecoder();
        byte[] byArray = new byte[33];
        int[] nArray = new int[160];
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray2 = new byte[320];
        if (string.equalsIgnoreCase("") || string2.equalsIgnoreCase("")) {
            System.err.print("Usage: GSMDriver inputfile outputfile\n");
            System.exit(1);
        }
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (Exception exception) {
            System.err.println("file not found, or can't open.\n");
            System.exit(2);
        }
        while (true) {
            block14: {
                try {
                    if (fileInputStream.read(byArray) <= 0) {
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    System.err.println("error reading inputArray");
                }
                break;
            }
            try {
                gSMDecoder.decode(byArray, nArray);
                for (int i = 0; i < 160; ++i) {
                    int n = i << 1;
                    byArray2[n] = (byte)(nArray[i] & 0xFF);
                    byArray2[++n] = (byte)((nArray[i] & 0xFF00) >> 8);
                }
                System.out.println("-");
                try {
                    fileOutputStream.write(byArray2);
                }
                catch (IOException iOException) {
                    System.err.println("error writing outputArray");
                    break;
                }
            }
            catch (InvalidGSMFrameException invalidGSMFrameException) {
                System.err.println("bad frame");
                break;
            }
        }
        try {
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("error closing files.");
        }
    }

    private static void encode(String string, String string2) {
        GSMEncoder gSMEncoder = new GSMEncoder();
        byte[] byArray = new byte[320];
        byte[] byArray2 = new byte[33];
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        int[] nArray = new int[160];
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (Exception exception) {
            System.err.println("file not found, or can't open.\n");
            System.exit(2);
        }
        while (true) {
            block11: {
                try {
                    if (fileInputStream.read(byArray) <= 0) {
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    System.err.println("error reading inputArray");
                }
                break;
            }
            int n = 0;
            while (n < 160) {
                int n2 = n << 1;
                nArray[n] = byArray[n2 + 1];
                int n3 = n;
                nArray[n3] = nArray[n3] << 8;
                int n4 = n++;
                nArray[n4] = nArray[n4] | byArray[n2++] & 0xFF;
            }
            gSMEncoder.encode(byArray2, nArray);
            try {
                fileOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                System.err.println("error writing outputArray");
                break;
            }
        }
        try {
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("error closing files.");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.print("Usage: GSMDriver d inputfile outputfile   -  decode from gsm file");
            System.err.print("       GSMDriver e inputfile outputfile   -  encode into gsm file");
            System.exit(2);
        }
        if (stringArray[0].equalsIgnoreCase("d")) {
            GSMDriver.decode(stringArray[1], stringArray[2]);
        } else if (stringArray[0].equalsIgnoreCase("e")) {
            GSMDriver.encode(stringArray[1], stringArray[2]);
        }
    }
}

