/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class UDPPacketSender
implements PacketConsumer {
    private DatagramSocket sock;
    private InetAddress address;
    private int port;
    private int ttl;

    public UDPPacketSender() throws IOException {
        this(new DatagramSocket());
    }

    public UDPPacketSender(DatagramSocket datagramSocket) {
        this.sock = datagramSocket;
    }

    public UDPPacketSender(InetAddress inetAddress, int n) throws IOException {
        if (inetAddress.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket();
            this.sock = multicastSocket;
        } else {
            this.sock = new DatagramSocket();
        }
        this.setRemoteAddress(inetAddress, n);
    }

    public UDPPacketSender(int n) throws IOException {
        this(new DatagramSocket(n));
    }

    public UDPPacketSender(int n, InetAddress inetAddress, InetAddress inetAddress2, int n2) throws IOException {
        if (inetAddress2.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket(n);
            if (inetAddress != null) {
                multicastSocket.setInterface(inetAddress);
            }
            this.sock = multicastSocket;
        } else if (inetAddress != null) {
            try {
                this.sock = new DatagramSocket(n, inetAddress);
            }
            catch (SocketException socketException) {
                System.out.println(socketException);
                System.out.println("localPort: " + n);
                System.out.println("localAddress: " + inetAddress);
                throw socketException;
            }
        } else {
            this.sock = new DatagramSocket(n);
        }
        this.setRemoteAddress(inetAddress2, n2);
    }

    public void closeConsumer() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public String consumerString() {
        String string = "UDP Datagram Packet Sender on port " + this.sock.getLocalPort();
        if (this.address != null) {
            string = string + " sending to address " + this.address + ", port " + this.port + ", ttl" + this.ttl;
        }
        return string;
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public void send(Packet packet, InetAddress inetAddress, int n) throws IOException {
        byte[] byArray = packet.data;
        if (packet.offset > 0) {
            byte[] byArray2 = byArray;
            byArray = new byte[packet.length];
            System.arraycopy(byArray2, packet.offset, byArray, 0, packet.length);
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, packet.length, inetAddress, n);
        this.sock.send(datagramPacket);
    }

    public void sendTo(Packet packet) throws IOException {
        InetAddress inetAddress = null;
        int n = 0;
        if (packet instanceof UDPPacket) {
            UDPPacket uDPPacket = (UDPPacket)packet;
            inetAddress = uDPPacket.remoteAddress;
            n = uDPPacket.remotePort;
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("No address set");
        }
        this.send(packet, inetAddress, n);
    }

    public void setRemoteAddress(InetAddress inetAddress, int n) {
        this.address = inetAddress;
        this.port = n;
    }

    public void setttl(int n) throws IOException {
        this.ttl = n;
        if (this.sock instanceof MulticastSocket) {
            ((MulticastSocket)this.sock).setTTL((byte)this.ttl);
        }
    }
}

