/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.utility.ByteBufferOutputStream;

public class RTCPCompoundPacket
extends RTCPPacket {
    public RTCPPacket[] packets;

    public RTCPCompoundPacket(Packet packet) {
        super(packet);
        this.type = -1;
    }

    public RTCPCompoundPacket(RTCPPacket[] rTCPPacketArray) {
        this.packets = rTCPPacketArray;
        this.type = -1;
        this.received = false;
    }

    public void assemble(DataOutputStream dataOutputStream) throws IOException {
        throw new IllegalArgumentException("Recursive Compound Packet");
    }

    public void assemble(int n, boolean bl) {
        int n2;
        int n3;
        this.length = n;
        this.offset = 0;
        byte[] byArray = new byte[n];
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(byArray, 0, n);
        DataOutputStream dataOutputStream = new DataOutputStream(byteBufferOutputStream);
        try {
            if (bl) {
                this.offset += 4;
            }
            n3 = this.offset;
            for (n2 = 0; n2 < this.packets.length; ++n2) {
                n3 = byteBufferOutputStream.size();
                this.packets[n2].assemble(dataOutputStream);
            }
        }
        catch (IOException iOException) {
            throw new NullPointerException("Impossible IO Exception");
        }
        n2 = byteBufferOutputStream.size();
        this.data = byArray;
        if (n2 > n) {
            throw new NullPointerException("RTCP Packet overflow");
        }
        if (n2 < n) {
            if (this.data.length < n) {
                this.data = new byte[n];
                System.arraycopy(this.data, 0, this.data, 0, n2);
            }
            int n4 = n3;
            this.data[n4] = (byte)(this.data[n4] | 0x20);
            this.data[n - 1] = (byte)(n - n2);
            int n5 = (this.data[n3 + 3] & 0xFF) + (n - n2 >> 2);
            if (n5 >= 256) {
                int n6 = n3 + 2;
                this.data[n6] = (byte)(this.data[n6] + (n - n2 >> 10));
            }
            this.data[n3 + 3] = (byte)n5;
        }
    }

    public int calcLength() {
        if (this.packets == null || this.packets.length < 1) {
            throw new IllegalArgumentException("Bad RTCP Compound Packet");
        }
        int n = 0;
        for (int i = 0; i < this.packets.length; ++i) {
            n += this.packets[i].calcLength();
        }
        return n;
    }

    public String toString() {
        return "RTCP Packet with the following subpackets:\n" + this.toString(this.packets);
    }

    public String toString(RTCPPacket[] rTCPPacketArray) {
        String string = "";
        for (int i = 0; i < rTCPPacketArray.length; ++i) {
            string = string + rTCPPacketArray[i];
        }
        return string;
    }
}

