/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.EntryViewCodec;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapGetEntryViewCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_GETENTRYVIEW;
    public static final int RESPONSE_TYPE = 113;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String name, Data key, long threadId) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, key, threadId);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(name);
        clientMessage.set(key);
        clientMessage.set(threadId);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        long threadId;
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data key = null;
        parameters.key = key = clientMessage.getData();
        parameters.threadId = threadId = clientMessage.getLong();
        return parameters;
    }

    public static ClientMessage encodeResponse(SimpleEntryView<Data, Data> dataEntryView) {
        int requiredDataSize = ResponseParameters.calculateDataSize(dataEntryView);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(113);
        if (dataEntryView == null) {
            boolean dataEntryView_isNull = true;
            clientMessage.set(dataEntryView_isNull);
        } else {
            boolean dataEntryView_isNull = false;
            clientMessage.set(dataEntryView_isNull);
            EntryViewCodec.encode(dataEntryView, clientMessage);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        SimpleEntryView dataEntryView = null;
        boolean dataEntryView_isNull = clientMessage.getBoolean();
        if (!dataEntryView_isNull) {
            parameters.dataEntryView = dataEntryView = EntryViewCodec.decode(clientMessage);
        }
        return parameters;
    }

    public static class ResponseParameters {
        public SimpleEntryView<Data, Data> dataEntryView;

        public static int calculateDataSize(SimpleEntryView<Data, Data> dataEntryView) {
            int dataSize = ClientMessage.HEADER_SIZE;
            ++dataSize;
            if (dataEntryView != null) {
                dataSize += EntryViewCodec.calculateDataSize(dataEntryView);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data key;
        public long threadId;

        public static int calculateDataSize(String name, Data key, long threadId) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateStringDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(key);
            return dataSize += 8;
        }
    }
}

