/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.Configuration;
import uk.ltd.getahead.dwr.Container;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.WebContextBuilder;
import uk.ltd.getahead.dwr.WebContextFactory;
import uk.ltd.getahead.dwr.util.Logger;
import uk.ltd.getahead.dwr.util.ServletLoggingOutput;

public abstract class AbstractDWRServlet
extends HttpServlet {
    protected Processor processor;
    protected WebContextBuilder builder;
    protected Container container;
    public static final String PACKAGE = "/uk/ltd/getahead/dwr";
    protected static final String INIT_SKIP_DEFAULT = "skipDefaultConfig";
    protected static final String INIT_CONFIG = "config";
    protected static final String INIT_LOGLEVEL = "logLevel";
    protected static final String FILE_DWR_XML = "/uk/ltd/getahead/dwr/dwr.xml";
    protected static final String DEFAULT_DWR_XML = "/WEB-INF/dwr.xml";
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.DWRServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    protected abstract Container getContainer(ServletConfig var1) throws ServletException;

    protected abstract void configure(ServletConfig var1, Configuration var2) throws ServletException;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            try {
                ServletLoggingOutput.setExecutionContext(this);
                String logLevel = config.getInitParameter(INIT_LOGLEVEL);
                if (logLevel != null) {
                    ServletLoggingOutput.setLevel(logLevel);
                }
                this.container = this.getContainer(config);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("uk.ltd.getahead.dwr.WebContextBuilder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.builder = (WebContextBuilder)this.container.getBean(clazz.getName());
                WebContextFactory.setWebContextBuilder(this.builder);
                this.builder.set(null, null, this.getServletConfig(), this.getServletContext(), this.container);
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("uk.ltd.getahead.dwr.Configuration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Configuration configuration = (Configuration)this.container.getBean(clazz2.getName());
                InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(FILE_DWR_XML);
                log.info("retrieved system configuration file: " + in);
                try {
                    configuration.addConfig(in);
                }
                catch (Exception ex) {
                    log.fatal("Failed to load system config file from dwr.jar", ex);
                    throw new ServletException(Messages.getString("DWRServlet.SystemConfigError"), (Throwable)ex);
                }
                this.configure(config, configuration);
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("uk.ltd.getahead.dwr.Processor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.processor = (Processor)this.container.getBean(clazz3.getName());
            }
            catch (ServletException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.fatal("init failed", ex);
                throw new ServletException((Throwable)ex);
            }
        }
        finally {
            if (this.builder != null) {
                this.builder.unset();
            }
            ServletLoggingOutput.unsetExecutionContext();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            this.builder.set(req, resp, this.getServletConfig(), this.getServletContext(), this.container);
            ServletLoggingOutput.setExecutionContext(this);
            this.processor.handle(req, resp);
        }
        finally {
            this.builder.unset();
            ServletLoggingOutput.unsetExecutionContext();
        }
    }

    protected void readFile(String configFile, Configuration configuration) throws ServletException {
        try {
            InputStream in = this.getServletContext().getResourceAsStream(configFile);
            if (in == null) {
                log.error("Missing config file: " + configFile);
            } else {
                configuration.addConfig(in);
            }
        }
        catch (Exception ex) {
            throw new ServletException(Messages.getString("DWRServlet.ConfigError", configFile), (Throwable)ex);
        }
    }
}

