/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.chatroom;

import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openymsg.network.Util;
import org.openymsg.network.chatroom.YahooChatLobby;
import org.openymsg.network.chatroom.YahooChatRoom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooChatCategory {
    private static final String PUBLIC_TYPE = "yahoo";
    private static final String CAT_URL = "insider.msg.yahoo.com/ycontent/?chatroom_";
    private final String name;
    private final long id;
    private final String cookieLine;
    private final Set<YahooChatCategory> subcategories;
    private final Set<YahooChatRoom> privateRooms;
    private final Set<YahooChatRoom> publicRooms;
    private final String localePrefix;
    private final Hashtable<String, YahooChatLobby> chatByNetName;

    public YahooChatCategory(long l, String string, String string2, String string3) {
        this.id = l;
        this.name = Util.entityDecode(string);
        this.cookieLine = string2;
        this.localePrefix = string3;
        this.subcategories = new HashSet<YahooChatCategory>();
        this.privateRooms = new HashSet<YahooChatRoom>();
        this.publicRooms = new HashSet<YahooChatRoom>();
        this.chatByNetName = new Hashtable();
    }

    public void addSubcategory(YahooChatCategory yahooChatCategory) {
        this.subcategories.add(yahooChatCategory);
    }

    public Set<YahooChatRoom> getPublicRooms() {
        return this.publicRooms;
    }

    public Set<YahooChatRoom> getPrivateRooms() {
        return this.privateRooms;
    }

    public Set<YahooChatCategory> getSubcategories() {
        return this.subcategories;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public YahooChatLobby getLobby(String string) {
        return this.chatByNetName.get(string);
    }

    public String toString() {
        return "YahooChatCategory [name=" + this.name + " id=" + this.id + ']';
    }

    public synchronized void loadRooms() throws Exception {
        this.publicRooms.clear();
        this.privateRooms.clear();
        String string = "http://" + this.localePrefix + CAT_URL;
        URLConnection uRLConnection = new URL(string + this.id).openConnection();
        Util.initURLConnection(uRLConnection);
        if (this.cookieLine != null) {
            uRLConnection.setRequestProperty("Cookie", this.cookieLine);
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(new URL(string + this.id));
        Element element = document.getRootElement().getChild("chatRooms");
        List list = element.getChildren("room");
        for (Element element2 : list) {
            String string2 = element2.getAttributeValue("type");
            long l = Long.parseLong(element2.getAttributeValue("id"));
            String string3 = element2.getAttributeValue("name");
            String string4 = element2.getAttributeValue("topic");
            YahooChatRoom yahooChatRoom = new YahooChatRoom(l, string3, string4, string2.equals(PUBLIC_TYPE));
            List list2 = element2.getChildren("lobby");
            for (Element element3 : list2) {
                int n = Integer.parseInt(element3.getAttributeValue("count"));
                int n2 = Integer.parseInt(element3.getAttributeValue("users", "-1"));
                int n3 = Integer.parseInt(element3.getAttributeValue("voices", "-1"));
                int n4 = Integer.parseInt(element3.getAttributeValue("webcams", "-1"));
                YahooChatLobby yahooChatLobby = yahooChatRoom.createLobby(n);
                yahooChatLobby.setReportedUsers(n2);
                yahooChatLobby.setReportedVoices(n3);
                yahooChatLobby.setReportedWebcams(n4);
                this.chatByNetName.put(yahooChatLobby.getNetworkName(), yahooChatLobby);
            }
            if (yahooChatRoom.isPublic()) {
                this.publicRooms.add(yahooChatRoom);
                continue;
            }
            this.privateRooms.add(yahooChatRoom);
        }
    }
}

