/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import redstone.xmlrpc.XmlRpcCustomSerializer;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcSerializer;
import redstone.xmlrpc.serializers.json.BooleanArraySerializer;
import redstone.xmlrpc.serializers.json.CollectionSerializer;
import redstone.xmlrpc.serializers.json.DoubleArraySerializer;
import redstone.xmlrpc.serializers.json.FloatArraySerializer;
import redstone.xmlrpc.serializers.json.IntArraySerializer;
import redstone.xmlrpc.serializers.json.IntrospectingSerializer;
import redstone.xmlrpc.serializers.json.ListSerializer;
import redstone.xmlrpc.serializers.json.MapSerializer;
import redstone.xmlrpc.serializers.json.ObjectArraySerializer;

public class XmlRpcJsonSerializer
extends XmlRpcSerializer {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-dd-mm HH:mm:ss");

    public XmlRpcJsonSerializer() {
        this(true);
    }

    public XmlRpcJsonSerializer(boolean bl) {
        super(false);
        if (bl) {
            this.customSerializers.add(new MapSerializer());
            this.customSerializers.add(new ListSerializer());
            this.customSerializers.add(new CollectionSerializer());
            this.customSerializers.add(new ObjectArraySerializer());
            this.customSerializers.add(new IntArraySerializer());
            this.customSerializers.add(new FloatArraySerializer());
            this.customSerializers.add(new DoubleArraySerializer());
            this.customSerializers.add(new BooleanArraySerializer());
            this.customSerializers.add(new IntrospectingSerializer());
        }
    }

    public void writeEnvelopeHeader(Object object, Writer writer) throws IOException {
        writer.write(40);
    }

    public void writeEnvelopeFooter(Object object, Writer writer) throws IOException {
        writer.write(41);
    }

    public void writeError(String string, Writer writer) throws IOException {
        writer.write(39);
        writer.write(string);
        writer.write(39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object object, Writer writer) throws XmlRpcException, IOException {
        if (object instanceof String || object instanceof Character) {
            writer.write(39);
            writer.write(object.toString());
            writer.write(39);
        } else if (object instanceof Number || object instanceof Boolean) {
            writer.write(object.toString());
        } else if (object instanceof Calendar) {
            writer.write("new Date('");
            SimpleDateFormat simpleDateFormat = dateFormatter;
            synchronized (simpleDateFormat) {
                writer.write(dateFormatter.format(((Calendar)object).getTime()));
            }
            writer.write("')");
        } else if (object instanceof Date) {
            writer.write("new Date('");
            SimpleDateFormat simpleDateFormat = dateFormatter;
            synchronized (simpleDateFormat) {
                writer.write(dateFormatter.format((Date)object));
            }
            writer.write("')");
        } else {
            for (int i = 0; i < this.customSerializers.size(); ++i) {
                XmlRpcCustomSerializer xmlRpcCustomSerializer = (XmlRpcCustomSerializer)this.customSerializers.get(i);
                if (!xmlRpcCustomSerializer.getSupportedClass().isInstance(object)) continue;
                xmlRpcCustomSerializer.serialize(object, writer, this);
                return;
            }
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcSerializer.UnsupportedType") + object.getClass());
        }
    }
}

