/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.ArrayList;
import java.util.Collection;
import org.openymsg.network.ServiceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YMSG9Packet {
    public String magic;
    public int version;
    public int length;
    public ServiceType service;
    public long status;
    public long sessionId;
    public String[] body;
    String quickSetAccessSeparator;
    int[] quickSetAccess = null;

    private int getNthLocation(String k, int n) {
        for (int i = 0; i < this.body.length; i += 2) {
            if (this.body[i].equals(k)) {
                --n;
            }
            if (n >= 0) continue;
            return i;
        }
        return -1;
    }

    String getNthValue(String k, int n) {
        int l = this.getNthLocation(k, n);
        if (l < 0) {
            return null;
        }
        return this.body[l + 1];
    }

    public String getValue(String k) {
        return this.getNthValue(k, 0);
    }

    String[] getValues(String k) {
        int cnt = 0;
        int j = 0;
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(k)) continue;
            ++cnt;
        }
        String[] sa = new String[cnt];
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(k)) continue;
            sa[j++] = this.body[i + 1];
        }
        return sa;
    }

    String getValueFromNthSet(String set, String k, int n) {
        int i = this.getNthLocation(set, n);
        if (i < 0) {
            return null;
        }
        i += 2;
        while (i < this.body.length) {
            if (this.body[i].equals(k)) {
                return this.body[i + 1];
            }
            if (this.body[i].equals(set)) {
                return null;
            }
            i += 2;
        }
        return null;
    }

    public Collection<String[]> entries() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < this.body.length; i += 2) {
            result.add(new String[]{this.body[i], this.body[i + 1]});
        }
        return result;
    }

    boolean exists(String k) {
        return this.getValue(k) != null;
    }

    void generateQuickSetAccessors(String separator) {
        if (this.quickSetAccess != null && this.quickSetAccessSeparator.equals(separator)) {
            return;
        }
        this.quickSetAccessSeparator = separator;
        int cnt = 0;
        for (int i = 0; i < this.body.length; i += 2) {
            if (!this.body[i].equals(separator)) continue;
            ++cnt;
        }
        this.quickSetAccess = new int[cnt + 1];
        int pos = 0;
        for (int i = 0; i < cnt; ++i) {
            while (pos < this.body.length && !this.body[pos].equals(separator)) {
                pos += 2;
            }
            this.quickSetAccess[i] = pos;
            pos += 2;
        }
        this.quickSetAccess[i] = this.body.length;
    }

    String getValueFromNthSetQA(String k, int n) {
        for (int i = this.quickSetAccess[n]; i < this.quickSetAccess[n + 1]; i += 2) {
            if (!this.body[i].equals(k)) continue;
            return this.body[i + 1];
        }
        return null;
    }

    boolean existsSetQA(String k, int n) {
        return this.getValueFromNthSetQA(k, n) != null;
    }

    void append(YMSG9Packet pkt) {
        String[] arr = new String[this.body.length + pkt.body.length];
        System.arraycopy(this.body, 0, arr, 0, this.body.length);
        System.arraycopy(pkt.body, 0, arr, this.body.length, pkt.body.length);
        this.body = arr;
    }

    void merge(YMSG9Packet pkt, String[] concatFields) {
        ArrayList<String> appendBuffer = new ArrayList<String>();
        for (int i = 0; i < pkt.body.length; i += 2) {
            String k = pkt.body[i];
            String v = pkt.body[i + 1];
            boolean b = false;
            for (int j = 0; j < concatFields.length; ++j) {
                if (!concatFields[j].equals(k)) continue;
                b = true;
                break;
            }
            if (b) {
                int idx = this.getNthLocation(k, 0);
                if (idx < 0) {
                    appendBuffer.add(k);
                    appendBuffer.add(pkt.body[i + 1]);
                    continue;
                }
                this.body[idx + 1] = this.body[idx + 1] + v;
                continue;
            }
            appendBuffer.add(k);
            appendBuffer.add(pkt.body[i + 1]);
        }
        if (appendBuffer.size() > 0) {
            String[] arr = new String[this.body.length + appendBuffer.size()];
            System.arraycopy(this.body, 0, arr, 0, this.body.length);
            for (int i = 0; i < appendBuffer.size(); ++i) {
                arr[this.body.length + i] = (String)appendBuffer.get(i);
            }
            this.body = arr;
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Magic:").append(this.magic);
        sb.append(" Version:").append(this.version);
        sb.append(" Length:").append(this.length);
        sb.append(" Service:").append((Object)this.service);
        sb.append(" Status:").append(this.status);
        sb.append(" SessionId:0x").append(Long.toHexString(this.sessionId));
        sb.append(" ");
        for (i = 0; i < this.body.length; ++i) {
            sb.append(" [" + this.body[i] + "]");
        }
        if (this.quickSetAccess != null) {
            sb.append(" ").append(this.quickSetAccessSeparator).append(":");
            for (i = 0; i < this.quickSetAccess.length; ++i) {
                sb.append(this.quickSetAccess[i]).append(" ");
            }
        }
        return sb.toString();
    }
}

