/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class RC4EncryptionExample {
    private static final String ALGORITHM = "RC4";
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;

    public RC4EncryptionExample(byte[] keyBytes) throws EncryptionException {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, ALGORITHM);
            this.encryptCipher = Cipher.getInstance(ALGORITHM);
            this.encryptCipher.init(1, key);
            this.decryptCipher = Cipher.getInstance(ALGORITHM);
            this.decryptCipher.init(2, key);
        }
        catch (Exception e) {
            throw new EncryptionException("Problem constucting " + this.getClass().getName(), e);
        }
    }

    public synchronized byte[] encrypt(byte[] data) throws EncryptionException {
        try {
            byte[] encryptedBytes = this.encryptCipher.doFinal(data);
            return encryptedBytes;
        }
        catch (Exception e) {
            throw new EncryptionException("Problem encrypting string", e);
        }
    }

    public synchronized byte[] decrypt(byte[] encryptedBytes) throws EncryptionException {
        try {
            byte[] data = this.decryptCipher.doFinal(encryptedBytes);
            return data;
        }
        catch (Exception e) {
            throw new EncryptionException("Problem decrypting string", e);
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] keyBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        RC4EncryptionExample encryptAgent = new RC4EncryptionExample(keyBytes);
        String dataString = args.length == 0 ? "The quick brown fox jumps over the lazy dog." : args[0];
        System.out.println(dataString.length() + " Data string ....................[" + dataString + "]");
        byte[] encryptedDataString = encryptAgent.encrypt(dataString.getBytes("utf-8"));
        BASE64Encoder base64Encoder = new BASE64Encoder();
        System.out.println(encryptedDataString.length + " Encoded encrypted data String ..[" + base64Encoder.encode(encryptedDataString) + "]");
        byte[] recoveredData = encryptAgent.decrypt(encryptedDataString);
        System.out.println("Recovered data string ..........[" + new String(recoveredData) + "]");
    }

    public static class EncryptionException
    extends Exception {
        private EncryptionException(String text, Exception chain) {
            super(text, chain);
        }
    }
}

