/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public abstract class AbstractTlvChain
implements TlvChain {
    private int totalSize;

    protected AbstractTlvChain() {
        this(-1);
    }

    protected AbstractTlvChain(int n) {
        DefensiveTools.checkRange(n, "totalSize", -1);
        this.totalSize = n;
    }

    protected final synchronized void copy(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        this.totalSize = this.getTotalSize();
        List list = this.getTlvList();
        Map map = this.getTlvMap();
        list.clear();
        map.clear();
        if (tlvChain instanceof AbstractTlvChain) {
            AbstractTlvChain abstractTlvChain = (AbstractTlvChain)tlvChain;
            list.addAll(abstractTlvChain.getTlvList());
            map.putAll(abstractTlvChain.getTlvMap());
        } else {
            Tlv[] tlvArray = tlvChain.getTlvs();
            for (int i = 0; i < tlvArray.length; ++i) {
                this.addTlvImpl(tlvArray[i]);
            }
        }
    }

    protected final synchronized void initFromBlock(ByteBlock byteBlock, int n) {
        DefensiveTools.checkNull(byteBlock, "block");
        DefensiveTools.checkRange(n, "maxTlvs", -1);
        int n2 = byteBlock.getOffset();
        for (int i = 0; Tlv.isValidTLV(byteBlock) && (n == -1 || i < n); ++i) {
            Tlv tlv = new Tlv(byteBlock);
            this.addTlvImpl(tlv);
            byteBlock = byteBlock.subBlock(tlv.getTotalSize());
        }
        this.totalSize = byteBlock.getOffset() - n2;
    }

    protected void addTlvImpl(Tlv tlv) {
        DefensiveTools.checkNull(tlv, "tlv");
        this.getTlvList().add(tlv);
        Integer n = new Integer(tlv.getType());
        List list = (List)this.getTlvMap().get(n);
        if (list == null) {
            list = this.createSiblingList();
            this.getTlvMap().put(n, list);
        }
        list.add(tlv);
    }

    public boolean hasTlv(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        return this.getTlvMap().containsKey(new Integer(n));
    }

    public Tlv[] getTlvs() {
        return this.getTlvList().toArray(new Tlv[0]);
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.getTlvList()).iterator();
    }

    public int getTlvCount() {
        return this.getTlvList().size();
    }

    public Tlv getFirstTlv(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        Integer n2 = new Integer(n);
        List list = (List)this.getTlvMap().get(n2);
        return list == null ? null : (Tlv)list.get(0);
    }

    public Tlv getLastTlv(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        Integer n2 = new Integer(n);
        List list = (List)this.getTlvMap().get(n2);
        return list == null ? null : (Tlv)list.get(list.size() - 1);
    }

    public Tlv[] getTlvs(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        Integer n2 = new Integer(n);
        List list = (List)this.getTlvMap().get(n2);
        if (list == null) {
            return new Tlv[0];
        }
        return list.toArray(new Tlv[0]);
    }

    public String getString(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        return this.hasTlv(n) ? this.getLastTlv(n).getDataAsString() : null;
    }

    public String getString(int n, String string) {
        DefensiveTools.checkRange(n, "type", 0);
        DefensiveTools.checkNull(string, "charset");
        if (!this.hasTlv(n)) {
            return null;
        }
        ByteBlock byteBlock = this.getLastTlv(n).getData();
        return OscarTools.getString(byteBlock, string);
    }

    public int getUShort(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        return this.hasTlv(n) ? this.getLastTlv(n).getDataAsUShort() : -1;
    }

    public long getUInt(int n) {
        Tlv tlv = this.getFirstTlv(n);
        if (tlv != null) {
            return tlv.getDataAsUInt();
        }
        return -1L;
    }

    public synchronized int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        int n = 0;
        Iterator iterator = this.getTlvList().iterator();
        while (iterator.hasNext()) {
            n = (int)((long)n + ((Tlv)iterator.next()).getWritableLength());
        }
        return n;
    }

    public void write(OutputStream outputStream) throws IOException {
        Iterator iterator = this.getTlvList().iterator();
        while (iterator.hasNext()) {
            Tlv tlv = (Tlv)iterator.next();
            tlv.write(outputStream);
        }
    }

    protected abstract List getTlvList();

    protected abstract Map getTlvMap();

    protected List createSiblingList() {
        return new LinkedList();
    }

    public String toString() {
        return this.getTlvList().toString();
    }
}

