/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icon.IconCommand;

public class IconRequest
extends IconCommand {
    public static final int CODE_DEFAULT = 1;
    private final String sn;
    private final int code;
    private final ExtraInfoBlock iconInfo;

    protected IconRequest(SnacPacket snacPacket) {
        super(4);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
        this.code = BinaryTools.getUByte(byteBlock2, 0);
        ByteBlock byteBlock3 = byteBlock2.subBlock(1);
        this.iconInfo = ExtraInfoBlock.readExtraInfoBlock(byteBlock3);
    }

    public IconRequest(String string, ExtraInfoBlock extraInfoBlock) {
        this(string, 1, extraInfoBlock);
    }

    public IconRequest(String string, int n, ExtraInfoBlock extraInfoBlock) {
        super(4);
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n, "code", 0);
        DefensiveTools.checkNull(extraInfoBlock, "iconInfo");
        this.sn = string;
        this.code = n;
        this.iconInfo = extraInfoBlock;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getCode() {
        return this.code;
    }

    public final ExtraInfoBlock getIconInfo() {
        return this.iconInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        BinaryTools.writeUByte(outputStream, this.code);
        this.iconInfo.write(outputStream);
    }

    public String toString() {
        return "IconRequest for " + this.sn + " (code=" + this.code + "): iconInfo=<" + this.iconInfo + ">";
    }
}

