/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class KeyRequest
extends AuthCommand {
    private static final int TYPE_SN = 1;
    private final String sn;

    protected KeyRequest(SnacPacket snacPacket) {
        super(6);
        DefensiveTools.checkNull(snacPacket, "packet");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(snacPacket.getData());
        this.sn = immutableTlvChain.getString(1);
    }

    public KeyRequest(String string) {
        super(6);
        this.sn = string;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(outputStream);
        }
        new Tlv(75).write(outputStream);
        new Tlv(90).write(outputStream);
    }

    public String toString() {
        return "KeyRequest for screenname " + this.sn;
    }
}

