/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.util.UUID;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jolokia.backend.Config;
import org.jolokia.backend.MBeanServerHandler;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.backend.executor.NotChangedException;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.discovery.JolokiaDiscovery;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.RequestHandlerManager;
import org.jolokia.history.HistoryStore;
import org.jolokia.request.JmxRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.DebugStore;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;

public class LocalRequestDispatcher
implements RequestDispatcher {
    private final String agentId;
    private MBeanServerHandler mBeanServerHandler;
    private RequestHandlerManager requestHandlerManager;
    private String qualifier;
    private LogHandler log;

    public LocalRequestDispatcher(Converters pConverters, Restrictor pRestrictor, Configuration pConfig, LogHandler pLogHandler) {
        this.mBeanServerHandler = new MBeanServerHandler(pConfig, pLogHandler);
        this.qualifier = pConfig.get(ConfigKey.MBEAN_QUALIFIER);
        this.log = pLogHandler;
        this.agentId = NetworkUtil.replaceExpression(pConfig.get(ConfigKey.AGENT_ID));
        this.requestHandlerManager = new RequestHandlerManager(pConfig, pConverters, this.mBeanServerHandler.getServerHandle(), pRestrictor);
    }

    public boolean canHandle(JmxRequest pJmxRequest) {
        return true;
    }

    public boolean useReturnValueWithPath(JmxRequest pJmxRequest) {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxRequest.getType());
        return handler.useReturnValueWithPath();
    }

    public Object dispatchRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, NotChangedException {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxReq.getType());
        return this.mBeanServerHandler.dispatchRequest(handler, pJmxReq);
    }

    public void initMBeans(HistoryStore pHistoryStore, DebugStore pDebugStore) throws MalformedObjectNameException, MBeanRegistrationException, NotCompliantMBeanException {
        String oName = this.createObjectNameWithQualifier("jolokia:type=Config");
        try {
            Config config = new Config(pHistoryStore, pDebugStore, oName);
            this.mBeanServerHandler.registerMBean(config, oName);
        }
        catch (InstanceAlreadyExistsException exp) {
            String alternativeOName = oName + ",uuid=" + UUID.randomUUID();
            try {
                this.log.info(oName + " is already registered. Adding it with " + alternativeOName + ", but you should revise your setup in " + "order to either use a qualifier or ensure, that only a single agent gets registered (otherwise history functionality might not work)");
                Config config = new Config(pHistoryStore, pDebugStore, alternativeOName);
                this.mBeanServerHandler.registerMBean(config, alternativeOName);
            }
            catch (InstanceAlreadyExistsException e) {
                this.log.error("Cannot even register fallback MBean with name " + alternativeOName + ". Should never happen. Really.", e);
            }
        }
        String legacyOName = this.createObjectNameWithQualifier("jmx4perl:type=Config");
        try {
            Config legacyConfig = new Config(pHistoryStore, pDebugStore, legacyOName);
            this.mBeanServerHandler.registerMBean(legacyConfig, legacyOName);
        }
        catch (InstanceAlreadyExistsException exp) {
            this.log.info("Cannot register (legacy) MBean handler for config store with name " + legacyOName + " since it already exists. " + "This is the case if another agent has been already started within the same JVM. The registration is skipped.");
        }
        try {
            this.mBeanServerHandler.registerMBean(new JolokiaDiscovery(this.agentId, this.log), "jolokia:type=Discovery");
        }
        catch (InstanceAlreadyExistsException e) {
            this.log.info("Jolokia Discovery MBean registration is skipped because there is already one registered.");
        }
    }

    public void destroy() throws JMException {
        this.mBeanServerHandler.destroy();
    }

    public ServerHandle getServerHandle() {
        return this.mBeanServerHandler.getServerHandle();
    }

    private String createObjectNameWithQualifier(String pOName) {
        return pOName + (this.qualifier != null ? "," + this.qualifier : "");
    }
}

