/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.components.DirectoryChooser;
import com.install4j.runtime.installer.frontend.components.NextScreenListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LinkScreen
extends InstallerScreen
implements NextScreenListener {
    public static final File DEFAULT_DIR = new File("/usr/local/bin");
    private DirectoryChooser directoryChooser;
    private JCheckBox chkDisable;

    public LinkScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
        this.checkEnabled();
    }

    public void nextScreen() {
        if (this.btnForward.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.btnForward, 0, null));
        }
    }

    public File getDestDir() {
        return this.chkDisable.isSelected() ? null : this.directoryChooser.getSelectedDirectory();
    }

    public void activate() {
        super.activate();
        this.directoryChooser.focusTextField();
    }

    protected boolean checkCompleted() {
        return this.directoryChooser.checkSelectedDirectory() && super.checkCompleted();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.messages.getString("SelectLinkDirLabel"), this.getApplicationName()), jPanel, gridBagConstraints);
        boolean bl = InstallerConfig.getCurrentInstance().isShowNeededSpace();
        if (!bl) {
            gridBagConstraints.insets.bottom = 5;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.directoryChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.chkDisable, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.chkDisable) {
            this.checkEnabled();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected String getTitle() {
        return this.messages.getString("WizardSelectLinkDir");
    }

    protected String getSubTitle() {
        return MessageFormat.format(this.messages.getString("SelectLinkDirDesc"), this.getApplicationName());
    }

    protected void setupControls() {
        super.setupControls();
        this.directoryChooser = new DirectoryChooser(DEFAULT_DIR, null, null, this);
        this.chkDisable = new JCheckBox(this.messages.getString("NoSymlinksCheck"));
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.chkDisable.addActionListener(this);
    }

    protected boolean needsSpacer() {
        return false;
    }

    private void checkEnabled() {
        boolean bl = !this.chkDisable.isSelected();
        this.directoryChooser.setEnabled(bl);
    }
}

