/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.jrobin.core.RrdFileBackend;

public class RrdSafeFileBackend
extends RrdFileBackend {
    private static final Counters counters = new Counters();
    private FileLock lock;

    public RrdSafeFileBackend(String string, long l, long l2) throws IOException {
        super(string, false);
        try {
            this.lockFile(l, l2);
        }
        catch (IOException iOException) {
            super.close();
            throw iOException;
        }
    }

    private void lockFile(long l, long l2) throws IOException {
        long l3 = System.currentTimeMillis();
        FileChannel fileChannel = this.file.getChannel();
        this.lock = fileChannel.tryLock(0L, Long.MAX_VALUE, false);
        if (this.lock != null) {
            counters.registerQuickLock();
            return;
        }
        do {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lock = fileChannel.tryLock(0L, Long.MAX_VALUE, false);
            if (this.lock == null) continue;
            counters.registerDelayedLock();
            return;
        } while (System.currentTimeMillis() - l3 <= l);
        counters.registerError();
        throw new IOException("Could not obtain exclusive lock on file: " + this.getPath() + "] after " + l + " milliseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
                counters.registerUnlock();
            }
        }
        finally {
            super.close();
        }
    }

    protected boolean isCachingAllowed() {
        return false;
    }

    public static String getLockInfo() {
        return counters.getInfo();
    }

    static class Counters {
        long locks;
        long quickLocks;
        long unlocks;
        long locked;
        long errors;

        Counters() {
        }

        synchronized void registerQuickLock() {
            ++this.locks;
            ++this.quickLocks;
            ++this.locked;
        }

        synchronized void registerDelayedLock() {
            ++this.locks;
            ++this.locked;
        }

        synchronized void registerUnlock() {
            ++this.unlocks;
            --this.locked;
        }

        synchronized void registerError() {
            ++this.errors;
        }

        synchronized String getInfo() {
            return "LOCKS=" + this.locks + ", " + "UNLOCKS=" + this.unlocks + ", " + "DELAYED_LOCKS=" + (this.locks - this.quickLocks) + ", " + "LOCKED=" + this.locked + ", " + "ERRORS=" + this.errors;
        }
    }
}

