/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import java.nio.ByteBuffer;

public class DeleteCommand
extends AbstractTextCommand {
    private final String key;
    private final int expiration;
    private final boolean noreply;
    ByteBuffer response = null;

    public DeleteCommand(String key, int expiration, boolean noreply) {
        super(TextCommandConstants.TextCommandType.DELETE);
        this.key = key;
        this.expiration = expiration;
        this.noreply = noreply;
    }

    public boolean doRead(ByteBuffer cb) {
        return true;
    }

    public void setResponse(byte[] value) {
        this.response = ByteBuffer.wrap(value);
    }

    public boolean writeTo(ByteBuffer bb) {
        if (this.response == null) {
            this.response = ByteBuffer.wrap(STORED);
        }
        while (bb.hasRemaining() && this.response.hasRemaining()) {
            bb.put(this.response.get());
        }
        return !this.response.hasRemaining();
    }

    public boolean shouldReply() {
        return !this.noreply;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return "DeleteCommand [" + (Object)((Object)this.type) + "]{" + "key='" + this.key + '\'' + ", expiration=" + this.expiration + ", noreply=" + this.noreply + '}' + super.toString();
    }
}

