/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import pl.mn.communicator.DefaultConnectionService;
import pl.mn.communicator.DefaultContactListService;
import pl.mn.communicator.DefaultLoginService;
import pl.mn.communicator.DefaultMessageService;
import pl.mn.communicator.DefaultPresenceService;
import pl.mn.communicator.DefaultPublicDirectoryService;
import pl.mn.communicator.DefaultRegistrationService;
import pl.mn.communicator.GGConfiguration;
import pl.mn.communicator.GGException;
import pl.mn.communicator.IConnectionService;
import pl.mn.communicator.IContactListService;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.IIncommingMessage;
import pl.mn.communicator.ILoginService;
import pl.mn.communicator.IMessageService;
import pl.mn.communicator.IPresenceService;
import pl.mn.communicator.IPublicDirectoryService;
import pl.mn.communicator.IRegistrationService;
import pl.mn.communicator.IRemoteStatus;
import pl.mn.communicator.ISession;
import pl.mn.communicator.IUser;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.PersonalInfo;
import pl.mn.communicator.PublicDirSearchReply;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.event.LoginFailedEvent;
import pl.mn.communicator.event.SessionStateListener;
import pl.mn.communicator.packet.in.GGIncomingPackage;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class Session
implements ISession {
    private SessionState m_sessionState = SessionState.CONNECTION_AWAITING;
    private SessionAccessor m_sessionAccessor = null;
    private Set m_sessionStateListeners = null;
    private HashMap m_sessionAttributes = null;
    private IGGConfiguration m_configuration = new GGConfiguration();
    private DefaultConnectionService m_connectionService = null;
    private DefaultLoginService m_loginService = null;
    private DefaultPresenceService m_presenceService = null;
    private DefaultMessageService m_messageService = null;
    private DefaultRegistrationService m_registrationService = null;
    private DefaultContactListService m_contactListService = null;
    private DefaultPublicDirectoryService m_publicDirectoryService = null;
    private HashMap m_proxies = new HashMap();

    public Session(IGGConfiguration configuration) {
        this();
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.m_configuration = configuration;
    }

    public Session() {
        this.m_sessionAccessor = new SessionAccessor();
        this.m_sessionAttributes = new HashMap();
        this.m_sessionStateListeners = new HashSet();
        this.m_connectionService = new DefaultConnectionService(this);
        this.m_loginService = new DefaultLoginService(this);
        this.m_messageService = new DefaultMessageService(this);
        this.m_presenceService = new DefaultPresenceService(this);
        this.m_contactListService = new DefaultContactListService(this);
        this.m_publicDirectoryService = new DefaultPublicDirectoryService(this);
        this.m_registrationService = new DefaultRegistrationService(this);
    }

    public SessionState getSessionState() {
        return this.m_sessionState;
    }

    public IGGConfiguration getGGConfiguration() {
        return this.m_configuration;
    }

    public void addSessionStateListener(SessionStateListener sessionStateListener) {
        if (sessionStateListener == null) {
            throw new NullPointerException("sessionStateListener cannot be null.");
        }
        this.m_sessionStateListeners.add(sessionStateListener);
    }

    public void removeSessionStateListener(SessionStateListener sessionStateListener) {
        if (sessionStateListener == null) {
            throw new NullPointerException("sessionStateListener cannot be null");
        }
        this.m_sessionStateListeners.remove(sessionStateListener);
    }

    public IConnectionService getConnectionService() {
        if (!this.m_proxies.containsKey(IConnectionService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_connectionService);
            IConnectionService connectionServiceProxy = (IConnectionService)Proxy.newProxyInstance(classLoader, new Class[]{IConnectionService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(IConnectionService.class.getName(), connectionServiceProxy);
        }
        return (IConnectionService)this.m_proxies.get(IConnectionService.class.getName());
    }

    public ILoginService getLoginService() {
        if (!this.m_proxies.containsKey(ILoginService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_loginService);
            ILoginService loginServiceProxy = (ILoginService)Proxy.newProxyInstance(classLoader, new Class[]{ILoginService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(ILoginService.class.getName(), loginServiceProxy);
        }
        return (ILoginService)this.m_proxies.get(ILoginService.class.getName());
    }

    public IMessageService getMessageService() {
        if (!this.m_proxies.containsKey(IMessageService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_messageService);
            IMessageService messageServiceProxy = (IMessageService)Proxy.newProxyInstance(classLoader, new Class[]{IMessageService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(IMessageService.class.getName(), messageServiceProxy);
        }
        return (IMessageService)this.m_proxies.get(IMessageService.class.getName());
    }

    public IPresenceService getPresenceService() {
        if (!this.m_proxies.containsKey(IPresenceService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_presenceService);
            IPresenceService presenceServiceProxy = (IPresenceService)Proxy.newProxyInstance(classLoader, new Class[]{IPresenceService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(IPresenceService.class.getName(), presenceServiceProxy);
        }
        return (IPresenceService)this.m_proxies.get(IPresenceService.class.getName());
    }

    public IPublicDirectoryService getPublicDirectoryService() {
        if (!this.m_proxies.containsKey(IPublicDirectoryService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_publicDirectoryService);
            IPublicDirectoryService publicDirectoryServiceProxy = (IPublicDirectoryService)Proxy.newProxyInstance(classLoader, new Class[]{IPublicDirectoryService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(IPublicDirectoryService.class.getName(), publicDirectoryServiceProxy);
        }
        return (IPublicDirectoryService)this.m_proxies.get(IPublicDirectoryService.class.getName());
    }

    public IContactListService getContactListService() {
        if (!this.m_proxies.containsKey(IContactListService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_contactListService);
            IContactListService contactListServiceProxy = (IContactListService)Proxy.newProxyInstance(classLoader, new Class[]{IContactListService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(IContactListService.class.getName(), contactListServiceProxy);
        }
        return (IContactListService)this.m_proxies.get(IContactListService.class.getName());
    }

    public IRegistrationService getRegistrationService() {
        if (!this.m_proxies.containsKey(IRegistrationService.class.getName())) {
            ClassLoader classLoader = Session.class.getClassLoader();
            SessionInvocationHandler invocationHandler = new SessionInvocationHandler(this.m_registrationService);
            IRegistrationService registrationServiceProxy = (IRegistrationService)Proxy.newProxyInstance(classLoader, new Class[]{IRegistrationService.class}, (InvocationHandler)invocationHandler);
            this.m_proxies.put(IRegistrationService.class.getName(), registrationServiceProxy);
        }
        return (IRegistrationService)this.m_proxies.get(IRegistrationService.class.getName());
    }

    protected void notifySessionStateChanged(SessionState oldState, SessionState newState) {
        if (oldState == null) {
            throw new NullPointerException("oldState cannot be null");
        }
        if (newState == null) {
            throw new NullPointerException("newState cannot be null");
        }
        Iterator it = this.m_sessionStateListeners.iterator();
        while (it.hasNext()) {
            SessionStateListener sessionStateListener = (SessionStateListener)it.next();
            if (oldState == newState) continue;
            sessionStateListener.sessionStateChanged(oldState, newState);
        }
    }

    public SessionAccessor getSessionAccessor() {
        return this.m_sessionAccessor;
    }

    private static final class SessionInvocationHandler
    implements InvocationHandler {
        private Object m_delegate = null;

        private SessionInvocationHandler(Object delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate cannot be null.");
            }
            this.m_delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.m_delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    public class SessionAccessor {
        public void setSessionState(SessionState sessionState) {
            if (Session.this.m_sessionState != sessionState) {
                SessionState oldState = Session.this.m_sessionState;
                Session.this.m_sessionState = sessionState;
                Session.this.notifySessionStateChanged(oldState, sessionState);
            }
        }

        public void sendPackage(GGOutgoingPackage outgoingPackage) throws IOException {
            Session.this.m_connectionService.sendPackage(outgoingPackage);
        }

        public void notifyConnectionEstablished() throws GGException {
            Session.this.m_connectionService.notifyConnectionEstablished();
        }

        public void notifyConnectionClosed() throws GGException {
            Session.this.m_connectionService.notifyConnectionClosed();
        }

        public void notifyConnectionError(Exception exception) throws GGException {
            Session.this.m_connectionService.notifyConnectionError(exception);
        }

        public void notifyPongReceived() {
            Session.this.m_connectionService.notifyPongReceived();
        }

        public void notifyLoginOK() throws GGException {
            Session.this.m_loginService.notifyLoginOK();
        }

        public void notifyLoggedOut() throws GGException {
            Session.this.m_loginService.notifyLoggedOut();
        }

        public void notifyLoginFailed(LoginFailedEvent loginFailedEvent) throws GGException {
            Session.this.m_loginService.notifyLoginFailed(loginFailedEvent);
        }

        public void notifyUserChangedStatus(IUser user, IRemoteStatus newStatus) throws GGException {
            Session.this.m_presenceService.notifyUserChangedStatus(user, newStatus);
        }

        public void notifyMessageArrived(IIncommingMessage incommingMessage) {
            Session.this.m_messageService.notifyMessageArrived(incommingMessage);
        }

        public void notifyMessageDelivered(int uin, int messageID, MessageStatus messageStatus) {
            Session.this.m_messageService.notifyMessageDelivered(uin, messageID, messageStatus);
        }

        public void notifyGGPacketReceived(GGIncomingPackage incomingPackage) {
            Session.this.m_connectionService.notifyPacketReceived(incomingPackage);
        }

        public void notifyContactListExported() {
            Session.this.m_contactListService.notifyContactListExported();
        }

        public void notifyContactListReceived(Collection contacts) {
            Session.this.m_contactListService.notifyContactListReceived(contacts);
        }

        public void notifyPubdirRead(int queryID, PersonalInfo publicDirInfo) {
            Session.this.m_publicDirectoryService.notifyPubdirRead(queryID, publicDirInfo);
        }

        public void notifyPubdirUpdated(int queryID) {
            Session.this.m_publicDirectoryService.notifyPubdirUpdated(queryID);
        }

        public void notifyPubdirGotSearchResults(int queryID, PublicDirSearchReply searchReply) {
            Session.this.m_publicDirectoryService.notifyPubdirGotSearchResults(queryID, searchReply);
        }

        public void setLoginSeed(int seed) {
            Session.this.m_sessionAttributes.put("seed", new Integer(seed));
        }

        public int getLoginSeed() {
            if (!Session.this.m_sessionAttributes.containsKey("seed")) {
                return -1;
            }
            Integer seedInteger = (Integer)Session.this.m_sessionAttributes.get("seed");
            return seedInteger;
        }

        public void disconnect() throws GGException {
            Session.this.m_connectionService.disconnect();
        }
    }
}

