/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.MapEventPublisher;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Clock;

public abstract class BaseRemoveOperation
extends LockAwareOperation
implements BackupAwareOperation,
MutatingOperation {
    protected transient Data dataOldValue;

    public BaseRemoveOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public BaseRemoveOperation() {
    }

    @Override
    public void afterRun() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        mapServiceContext.interceptAfterRemove(this.name, this.dataValue);
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.REMOVED, this.dataKey, this.dataOldValue, null);
        this.invalidateNearCaches();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            mapEventPublisher.publishWanReplicationRemove(this.name, this.dataKey, Clock.currentTimeMillis());
        }
        this.evict(false);
    }

    @Override
    public Object getResponse() {
        return this.dataOldValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveBackupOperation(this.name, this.dataKey);
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    public String toString() {
        return "BaseRemoveOperation{" + this.name + "}";
    }
}

