/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public abstract class AbstractRvIcbm
extends AbstractIcbm {
    public static final int RVSTATUS_REQUEST = 0;
    public static final int RVSTATUS_ACCEPT = 2;
    public static final int RVSTATUS_DENY = 1;
    private static final int TYPE_RV_DATA = 5;
    private int status;
    private long rvSessionId;
    private CapabilityBlock cap;
    private ByteBlock rvData;
    private LiveWritable rvDataWriter;

    protected AbstractRvIcbm(int n, SnacPacket snacPacket) {
        super(4, n, snacPacket);
    }

    final void processRvTlvs(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        Tlv tlv = tlvChain.getLastTlv(5);
        if (tlv == null) {
            this.status = -1;
            this.rvSessionId = 0L;
            this.cap = null;
            this.rvData = null;
            this.rvDataWriter = null;
        } else {
            ByteBlock byteBlock = tlv.getData();
            this.status = BinaryTools.getUShort(byteBlock, 0);
            this.rvSessionId = BinaryTools.getLong(byteBlock, 2);
            if (byteBlock.getLength() >= 26) {
                ByteBlock byteBlock2 = byteBlock.subBlock(10, 16);
                this.cap = new CapabilityBlock(byteBlock2);
                this.rvData = byteBlock.subBlock(26);
            } else {
                this.cap = null;
                this.rvData = null;
            }
            this.rvDataWriter = this.rvData;
        }
    }

    protected AbstractRvIcbm(int n, long l, int n2, long l2, CapabilityBlock capabilityBlock, LiveWritable liveWritable) {
        super(4, n, l, 2);
        DefensiveTools.checkRange(n2, "status", 0);
        DefensiveTools.checkNull(capabilityBlock, "cap");
        DefensiveTools.checkNull(liveWritable, "rvDataWriter");
        this.status = n2;
        this.rvSessionId = l2;
        this.cap = capabilityBlock;
        this.rvData = null;
        this.rvDataWriter = liveWritable;
    }

    protected AbstractRvIcbm(int n, long l, long l2, final RvCommand rvCommand) {
        this(n, l, rvCommand.getRvStatus(), l2, rvCommand.getCapabilityBlock(), new LiveWritable(){

            public void write(OutputStream outputStream) throws IOException {
                rvCommand.writeRvData(outputStream);
            }
        });
    }

    public final int getRvStatus() {
        return this.status;
    }

    public final long getRvSessionId() {
        return this.rvSessionId;
    }

    public final CapabilityBlock getCapability() {
        return this.cap;
    }

    public final ByteBlock getRvData() {
        return this.rvData;
    }

    final void writeRvTlvs(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryTools.writeUShort(byteArrayOutputStream, this.status);
        BinaryTools.writeLong(byteArrayOutputStream, this.rvSessionId);
        this.cap.write(byteArrayOutputStream);
        this.rvDataWriter.write(byteArrayOutputStream);
        new Tlv(5, ByteBlock.wrap(byteArrayOutputStream.toByteArray())).write(outputStream);
    }

    public String toString() {
        return "AbstractRvIcbm: status=" + this.status + ", rvSessionId=" + this.rvSessionId + ", on top of " + super.toString();
    }
}

