/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

public class WinAPIWrapper {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int ERROR_SUCCESS = 0;
    public static final int MAX_KEY_LENGTH = 255;
    private static final int OPENED_KEY_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    public static final int KEY_READ = 131097;

    private static native int[] RegOpenKey(int var0, byte[] var1, int var2);

    private static native int RegCloseKey(int var0);

    private static native byte[] RegQueryValueEx(int var0, byte[] var1);

    private static native byte[] AssocQueryString(byte[] var0, byte[] var1);

    private static native byte[] ExpandEnvironmentStrings(byte[] var0);

    private static native String resolveLinkFile(byte[] var0);

    private static native int shellExecute(byte[] var0, byte[] var1);

    private static synchronized native void openMapiMailer(String[] var0, String[] var1, String[] var2, String var3, String var4, String[] var5);

    protected static native void shutDown();

    private static native boolean nativeBrowseURLInIE(String var0, String var1);

    private static byte[] stringToByteArray(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = 0;
        return byArray2;
    }

    private static String byteArrayToString(byte[] byArray) {
        String string;
        if (byArray != null && (string = new String(byArray)) != null) {
            return string.substring(0, string.length() - 1);
        }
        return null;
    }

    private WinAPIWrapper() {
    }

    public static String WinRegQueryValueEx(int n, String string, String string2) {
        byte[] byArray = WinAPIWrapper.stringToByteArray(string);
        int[] nArray = WinAPIWrapper.RegOpenKey(n, byArray, 131097);
        if (nArray == null) {
            return null;
        }
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray2 = WinAPIWrapper.stringToByteArray(string2);
        byte[] byArray3 = WinAPIWrapper.RegQueryValueEx(nArray[0], byArray2);
        WinAPIWrapper.RegCloseKey(nArray[0]);
        if (byArray3 != null) {
            if (byArray3.length == 1 && byArray3[0] == 0 && string2.equals("")) {
                return null;
            }
            return WinAPIWrapper.byteArrayToString(byArray3);
        }
        return null;
    }

    public static String WinAssocQueryString(String string, String string2) {
        byte[] byArray;
        byte[] byArray2 = WinAPIWrapper.stringToByteArray(string);
        byte[] byArray3 = WinAPIWrapper.AssocQueryString(byArray2, byArray = WinAPIWrapper.stringToByteArray(string2));
        if (byArray3 != null) {
            if (byArray3.length == 1 && byArray3[0] == 0 && byArray3.equals("")) {
                return null;
            }
            return WinAPIWrapper.byteArrayToString(byArray3);
        }
        return null;
    }

    public static String WinResolveLinkFile(String string) {
        byte[] byArray = WinAPIWrapper.stringToByteArray(string);
        return WinAPIWrapper.resolveLinkFile(byArray);
    }

    public static boolean WinShellExecute(String string, String string2) {
        byte[] byArray;
        byte[] byArray2 = WinAPIWrapper.stringToByteArray(string);
        int n = WinAPIWrapper.shellExecute(byArray2, byArray = WinAPIWrapper.stringToByteArray(string2));
        return n > 32;
    }

    public static boolean WinBrowseURLInIE(String string, String string2) {
        return WinAPIWrapper.nativeBrowseURLInIE(string, string2);
    }

    public static synchronized void WinOpenMapiMailer(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String[] stringArray4) {
        WinAPIWrapper.openMapiMailer(stringArray, stringArray2, stringArray3, string, string2, stringArray4);
    }

    static {
        System.loadLibrary("jdic");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WinAPIWrapper.shutDown();
            }
        });
    }
}

