/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import net.sf.antcontrib.property.Num;
import net.sf.antcontrib.property.Op;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MathTask
extends Task {
    private String result = null;
    private Op op = null;
    private String operation = null;
    private String operand1 = null;
    private String operand2 = null;
    private String datatype = null;
    private boolean strict = false;

    public void setResult(String string) {
        this.result = string;
    }

    public void setDatatype(String string) {
        if (string.equals("int")) {
            this.datatype = "int";
        } else if (string.equals("long")) {
            this.datatype = "long";
        } else if (string.equals("float")) {
            this.datatype = "float";
        } else if (string.equals("double")) {
            this.datatype = "double";
        } else {
            throw new BuildException("Invalid datatype: " + string + ". Must be one of int, long, float, or double.");
        }
    }

    public void setOperand1(String string) throws BuildException {
        this.operand1 = string;
    }

    public void setOperand2(String string) throws BuildException {
        this.operand2 = string;
    }

    public void setOperation(String string) {
        this.operation = string;
    }

    public void addConfiguredOp(Op op) {
        if (this.op != null) {
            throw new BuildException("Only one operation allowed at a time!");
        }
        if (this.datatype != null) {
            op.setDatatype(this.datatype);
        }
        this.op = op;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public void execute() {
        Num num;
        if (this.result == null) {
            throw new BuildException("Property name for result is null.");
        }
        if (this.datatype == null) {
            this.datatype = "double";
        }
        if (this.operation != null) {
            this.op = new Op();
            if (this.datatype == null) {
                this.datatype = "double";
            }
            this.op.setDatatype(this.datatype);
            this.op.setOp(this.operation);
            if (this.operand1 != null) {
                num = new Num();
                num.setValue(this.operand1);
                this.op.addNum(num);
            }
            if (this.operand2 != null) {
                num = new Num();
                num.setValue(this.operand2);
                this.op.addNum(num);
            }
        }
        if (this.op == null) {
            throw new BuildException("Nothing to do!");
        }
        this.op.setDatatype(this.datatype);
        this.op.setStrict(this.strict);
        num = this.op.calculate();
        this.getProject().setUserProperty(this.result, num.getValue().toString());
    }
}

