/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MysqlDataSourceFactory
implements ObjectFactory {
    protected static final String DATA_SOURCE_CLASS_NAME = "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
    protected static final String POOL_DATA_SOURCE_CLASS_NAME = "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource";

    public Object getObjectInstance(Object refObj, Name nm, Context ctx, Hashtable env) throws Exception {
        Reference ref = (Reference)refObj;
        String className = ref.getClassName();
        if (className != null && (className.equals(DATA_SOURCE_CLASS_NAME) || className.equals(POOL_DATA_SOURCE_CLASS_NAME))) {
            String explicitUrlAsString;
            String databaseName;
            String serverName;
            String password;
            MysqlDataSource dataSource = null;
            try {
                dataSource = (MysqlDataSource)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create DataSource of class '" + className + "', reason: " + ex.toString());
            }
            int portNumber = 3306;
            String portNumberAsString = (String)ref.get("port").getContent();
            if (portNumberAsString != null) {
                portNumber = Integer.parseInt(portNumberAsString);
            }
            dataSource.setPort(portNumber);
            String user = (String)ref.get("user").getContent();
            if (user != null) {
                dataSource.setUser(user);
            }
            if ((password = (String)ref.get("password").getContent()) != null) {
                dataSource.setPassword(password);
            }
            if ((serverName = (String)ref.get("serverName").getContent()) != null) {
                dataSource.setServerName(serverName);
            }
            if ((databaseName = (String)ref.get("databaseName").getContent()) != null) {
                dataSource.setDatabaseName(databaseName);
            }
            if ((explicitUrlAsString = (String)ref.get("explicitUrl").getContent()) != null && Boolean.valueOf(explicitUrlAsString).booleanValue()) {
                dataSource.setUrl((String)ref.get("url").getContent());
            }
            dataSource.setPropertiesViaRef(ref);
            return dataSource;
        }
        return null;
    }
}

