/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.debug;

import java.util.Vector;
import net.sf.jqql.debug.IDebugListener;
import net.sf.jqql.debug.IDebugObject;

public class DebugSwitch {
    private Vector<IDebugListener> listeners = new Vector();
    private boolean debug = false;
    private static DebugSwitch instance = new DebugSwitch();

    private DebugSwitch() {
    }

    public static DebugSwitch getInstance() {
        return instance;
    }

    public void addDebugListener(IDebugListener iDebugListener) {
        if (iDebugListener != null) {
            this.listeners.add(iDebugListener);
        }
        if (this.listeners.size() > 0) {
            this.debug = true;
        }
    }

    public void removeDebugListener(IDebugListener iDebugListener) {
        if (iDebugListener != null) {
            this.listeners.remove(iDebugListener);
        }
        if (this.listeners.size() <= 0) {
            this.debug = false;
        }
    }

    public void deliverDebugObject(IDebugObject iDebugObject) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            this.listeners.get(i).deliverDebugObject(iDebugObject);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

