/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.FontStyle;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicOutPacket;

public class SendIMPacket
extends _08BasicOutPacket {
    private FontStyle fontStyle;
    private int receiver;
    private byte[] message;
    private char messageType;
    private byte replyType;
    private int totalFragments;
    private int fragmentSequence;
    private char messageId;
    private String fileName;
    private String fileSize;
    private char directPort;
    private char localPort;
    private byte[] localIp;
    private char sessionId;
    private byte transferType;
    private boolean fakeIp;
    private static final byte DELIMIT = 31;

    public SendIMPacket(QQUser qQUser) {
        super('\u0016', true, qQUser);
        this.fontStyle = new FontStyle();
        this.message = null;
        this.messageType = (char)11;
        this.replyType = 1;
        this.transferType = (byte)101;
        this.fakeIp = false;
        this.totalFragments = 1;
        this.fragmentSequence = 0;
    }

    public SendIMPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Send IM _08Packet";
    }

    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.user.getQQ());
        byteBuffer.putInt(this.receiver);
        byteBuffer.putChar(this.source);
        byteBuffer.putInt(this.user.getQQ());
        byteBuffer.putInt(this.receiver);
        byteBuffer.put(this.user.getFileSessionKey());
        byteBuffer.putChar(this.messageType);
        if (this.sessionId == '\u0000') {
            byteBuffer.putChar(this.sequence);
        } else {
            byteBuffer.putChar(this.sessionId);
        }
        int n = (int)(System.currentTimeMillis() / 1000L);
        byteBuffer.putInt(n);
        char c = (char)this.user.getContactInfo().head;
        byteBuffer.putChar(c);
        byteBuffer.putInt(1);
        if (this.fakeIp) {
            byteBuffer.putInt(0);
        } else {
            byteBuffer.put((byte)this.totalFragments);
            byteBuffer.put((byte)this.fragmentSequence);
            byteBuffer.putChar(this.messageId);
        }
        switch (this.messageType) {
            case '\u000b': {
                this.initTextContent(byteBuffer);
                break;
            }
            case '5': {
                this.initSendFileContent(byteBuffer);
                break;
            }
            case '7': {
                this.initSendFileAcceptContent(byteBuffer);
                break;
            }
            case '\u0005': 
            case '9': {
                this.initSendFileRejectContent(byteBuffer);
                break;
            }
            case ';': {
                this.initNotifyFilePortUDP(byteBuffer);
                break;
            }
            case 'I': {
                this.initConnectionCanceled(byteBuffer);
                break;
            }
            case '?': {
                this.initPleaseConnectMe(byteBuffer);
            }
        }
    }

    private void initPleaseConnectMe(ByteBuffer byteBuffer) {
        byteBuffer.putLong(0L);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)0);
        byteBuffer.put(this.transferType);
        byteBuffer.put((byte)0);
        byteBuffer.put(this.user.getIp());
        byteBuffer.putChar((char)this.user.getPort());
        byteBuffer.putChar(this.directPort);
        byteBuffer.putInt(0);
        byteBuffer.putChar('\u0000');
    }

    private void initConnectionCanceled(ByteBuffer byteBuffer) {
        byteBuffer.putLong(0L);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)0);
        byteBuffer.put(this.transferType);
    }

    private void initNotifyFilePortUDP(ByteBuffer byteBuffer) {
        byteBuffer.putLong(0L);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)0);
        byteBuffer.put(this.transferType);
        byteBuffer.put((byte)0);
        byteBuffer.put(this.user.getIp());
        byteBuffer.putChar((char)this.user.getPort());
        byteBuffer.putChar(this.directPort);
        byteBuffer.put(this.localIp);
        byteBuffer.putChar(this.localPort);
    }

    private void initSendFileRejectContent(ByteBuffer byteBuffer) {
        byteBuffer.putLong(0L);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)0);
        byteBuffer.put(this.transferType);
    }

    private void initSendFileAcceptContent(ByteBuffer byteBuffer) {
        byteBuffer.putLong(0L);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)0);
        byteBuffer.put(this.transferType);
        byteBuffer.put((byte)0);
        byteBuffer.put(this.user.getIp());
        byteBuffer.putChar((char)this.user.getPort());
        byteBuffer.putChar(this.directPort);
        byteBuffer.putInt(0);
        byteBuffer.putChar('\u0000');
    }

    private void initSendFileContent(ByteBuffer byteBuffer) {
        byteBuffer.putLong(0L);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)0);
        byteBuffer.put(this.transferType);
        byteBuffer.put((byte)0);
        if (this.fakeIp) {
            byteBuffer.putInt(0);
            byteBuffer.putChar('\u0000');
        } else {
            byteBuffer.put(this.user.getIp());
            byteBuffer.putChar((char)this.user.getPort());
        }
        byteBuffer.putChar(this.directPort);
        byteBuffer.putInt(0);
        byteBuffer.putChar('\u0000');
        byteBuffer.put((byte)32);
        byteBuffer.put((byte)31);
        byteBuffer.put(this.fileName.getBytes());
        byteBuffer.put((byte)31);
        byteBuffer.put(this.fileSize.getBytes());
    }

    private void initTextContent(ByteBuffer byteBuffer) {
        byteBuffer.put(this.replyType);
        if (this.message != null) {
            byteBuffer.put(this.message);
        }
        if (this.fragmentSequence == this.totalFragments - 1) {
            byteBuffer.put((byte)32);
        }
        this.fontStyle.writeBean(byteBuffer);
    }

    public int getBlue() {
        return this.fontStyle.getBlue();
    }

    public void setBlue(int n) {
        this.fontStyle.setBlue(n);
    }

    public boolean isBold() {
        return this.fontStyle.isBold();
    }

    public void setBold(boolean bl) {
        this.fontStyle.setBold(bl);
    }

    public char getEncoding() {
        return this.fontStyle.getEncodingCode();
    }

    public void setEncoding(char c) {
        this.fontStyle.setEncodingCode(c);
    }

    public String getFontName() {
        return this.fontStyle.getFontName();
    }

    public void setFontName(String string) {
        this.fontStyle.setFontName(string);
    }

    public int getGreen() {
        return this.fontStyle.getGreen();
    }

    public void setGreen(int n) {
        this.fontStyle.setGreen(n);
    }

    public boolean isItalic() {
        return this.fontStyle.isItalic();
    }

    public void setItalic(boolean bl) {
        this.fontStyle.setItalic(bl);
    }

    public int getRed() {
        return this.fontStyle.getRed();
    }

    public void setRed(int n) {
        this.fontStyle.setRed(n);
    }

    public boolean isUnderline() {
        return this.fontStyle.isUnderline();
    }

    public void setUnderline(boolean bl) {
        this.fontStyle.setUnderline(bl);
    }

    public int getFontSize() {
        return this.fontStyle.getFontSize();
    }

    public void setFontSize(int n) {
        this.fontStyle.setFontSize(n);
    }

    public int getReceiver() {
        return this.receiver;
    }

    public void setReceiver(int n) {
        this.receiver = n;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public void setMessageType(char c) {
        this.messageType = c;
    }

    public byte getReplyType() {
        return this.replyType;
    }

    public void setReplyType(byte by) {
        this.replyType = by;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFileSize(int n) {
        this.fileSize = String.valueOf(n) + " \u5b57\u8282";
    }

    public void setDirectPort(int n) {
        this.directPort = (char)n;
    }

    public char getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(char c) {
        this.sessionId = c;
    }

    public byte[] getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(byte[] byArray) {
        this.localIp = byArray;
    }

    public char getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int n) {
        this.localPort = (char)n;
    }

    public byte getTransferType() {
        return this.transferType;
    }

    public void setTransferType(byte by) {
        this.transferType = by;
    }

    public boolean isFakeIp() {
        return this.fakeIp;
    }

    public void setFakeIp(boolean bl) {
        this.fakeIp = bl;
    }

    public int getFragmentSequence() {
        return this.fragmentSequence;
    }

    public void setFragmentSequence(int n) {
        this.fragmentSequence = n;
    }

    public int getTotalFragments() {
        return this.totalFragments;
    }

    public void setTotalFragments(int n) {
        this.totalFragments = n;
    }

    public char getMessageId() {
        return this.messageId;
    }

    public void setMessageId(char c) {
        this.messageId = c;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }
}

