/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NearCache {
    private static final Object NULL_OBJECT = new Object();
    private static final int evictionPercentage = 20;
    private static final int cleanupInterval = 5000;
    private final int maxSize;
    private volatile long lastCleanup;
    private final long maxIdleMillis;
    private final long timeToLiveMillis;
    private final EvictionPolicy evictionPolicy;
    private final InMemoryFormat inMemoryFormat;
    private final MapService mapService;
    private final NodeEngine nodeEngine;
    private final AtomicBoolean canCleanUp;
    private final AtomicBoolean canEvict;
    private final ConcurrentMap<Data, CacheRecord> cache;
    private final MapContainer mapContainer;

    public NearCache(String mapName, MapService mapService) {
        this.mapService = mapService;
        this.nodeEngine = mapService.getNodeEngine();
        this.mapContainer = mapService.getMapContainer(mapName);
        Config config = this.nodeEngine.getConfig();
        NearCacheConfig nearCacheConfig = config.findMapConfig(mapName).getNearCacheConfig();
        this.maxSize = nearCacheConfig.getMaxSize() <= 0 ? Integer.MAX_VALUE : nearCacheConfig.getMaxSize();
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.cache = new ConcurrentHashMap<Data, CacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
    }

    public void put(Data key, Data data) {
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        Object value = data == null ? NULL_OBJECT : (this.inMemoryFormat.equals((Object)InMemoryFormat.OBJECT) ? this.mapService.toObject(data) : data);
        CacheRecord record = new CacheRecord(key, value);
        this.cache.put(key, record);
        this.updateSizeEstimator(this.calculateCost(record));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                this.nodeEngine.getExecutionService().execute("hz:near-cache", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(NearCache.this.cache.values());
                            int evictSize = NearCache.this.cache.size() * 20 / 100;
                            int i = 0;
                            for (CacheRecord record : records) {
                                NearCache.this.cache.remove(record.key);
                                NearCache.this.updateSizeEstimator(-NearCache.this.calculateCost(record));
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            NearCache.this.canEvict.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.nodeEngine.getExecutionService().execute("hz:near-cache", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            NearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : NearCache.this.cache.entrySet()) {
                                if (!((CacheRecord)entry.getValue()).expired()) continue;
                                Data key = (Data)entry.getKey();
                                CacheRecord record = (CacheRecord)NearCache.this.cache.remove(key);
                                if (record == null) continue;
                                NearCache.this.updateSizeEstimator(-NearCache.this.calculateCost(record));
                            }
                        }
                        finally {
                            NearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    public Object get(Data key) {
        this.fireTtlCleanup();
        CacheRecord record = (CacheRecord)this.cache.get(key);
        if (record != null) {
            record.access();
            if (record.expired()) {
                this.cache.remove(key);
                this.updateSizeEstimator(-this.calculateCost(record));
                return null;
            }
            return record.value.equals(NULL_OBJECT) ? null : record.value;
        }
        return null;
    }

    public void invalidate(Data key) {
        CacheRecord record = (CacheRecord)this.cache.remove(key);
        if (record != null) {
            this.updateSizeEstimator(-this.calculateCost(record));
        }
    }

    public int size() {
        return this.cache.size();
    }

    void clear() {
        this.cache.clear();
        this.resetSizeEstimator();
    }

    private void resetSizeEstimator() {
        this.mapContainer.getNearCacheSizeEstimator().reset();
    }

    private void updateSizeEstimator(long size) {
        this.mapContainer.getNearCacheSizeEstimator().add(size);
    }

    private long calculateCost(CacheRecord record) {
        return this.mapContainer.getNearCacheSizeEstimator().getCost(record);
    }

    public class CacheRecord
    implements Comparable<CacheRecord> {
        final Data key;
        final Object value;
        final long creationTime;
        final AtomicInteger hit;
        volatile long lastAccessTime;

        CacheRecord(Data key, Object value) {
            long time;
            this.key = key;
            this.value = value;
            this.lastAccessTime = time = Clock.currentTimeMillis();
            this.creationTime = time;
            this.hit = new AtomicInteger(0);
        }

        void access() {
            this.hit.incrementAndGet();
            this.lastAccessTime = Clock.currentTimeMillis();
        }

        boolean expired() {
            long time = Clock.currentTimeMillis();
            return NearCache.this.maxIdleMillis > 0L && time > this.lastAccessTime + NearCache.this.maxIdleMillis || NearCache.this.timeToLiveMillis > 0L && time > this.creationTime + NearCache.this.timeToLiveMillis;
        }

        @Override
        public int compareTo(CacheRecord o) {
            if (EvictionPolicy.LRU.equals((Object)NearCache.this.evictionPolicy)) {
                return Long.valueOf(this.lastAccessTime).compareTo(o.lastAccessTime);
            }
            if (EvictionPolicy.LFU.equals((Object)NearCache.this.evictionPolicy)) {
                return Integer.valueOf(this.hit.get()).compareTo(o.hit.get());
            }
            return 0;
        }

        public long getCost() {
            if (!(this.value instanceof Data)) {
                return 0L;
            }
            return this.key.getHeapCost() + ((Data)this.value).getHeapCost() + 16 + 4 + 12;
        }

        public Data getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    static enum EvictionPolicy {
        NONE,
        LRU,
        LFU;

    }
}

