/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.operation.ThreadDumpOperation;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class ThreadDumpRequest
implements ConsoleRequest {
    private boolean isDeadlock;
    private Address target;

    public ThreadDumpRequest() {
    }

    public ThreadDumpRequest(Address target, boolean deadlock) {
        this.target = target;
        this.isDeadlock = deadlock;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        String threadDump = (String)mcs.callOnAddress(this.target, new ThreadDumpOperation(this.isDeadlock));
        if (threadDump != null) {
            dos.writeBoolean(true);
            IOUtil.writeLongString(dos, threadDump);
        } else {
            dos.writeBoolean(false);
        }
    }

    @Override
    public String readResponse(ObjectDataInput in) throws IOException {
        if (in.readBoolean()) {
            return IOUtil.readLongString(in);
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.target.writeData(out);
        out.writeBoolean(this.isDeadlock);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.target = new Address();
        this.target.readData(in);
        this.isDeadlock = in.readBoolean();
    }
}

