/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.nio.charset.Charset;
import java.util.Locale;

public final class StringUtil {
    private static final Locale LOCALE_INTERNAL = Locale.ENGLISH;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    private StringUtil() {
    }

    public static String bytesToString(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, UTF8_CHARSET);
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes, UTF8_CHARSET);
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes(UTF8_CHARSET);
    }

    public static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    public static String upperCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toUpperCase(LOCALE_INTERNAL);
    }

    public static String lowerCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toLowerCase(LOCALE_INTERNAL);
    }
}

