/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.netaddr;

import net.java.sip.communicator.impl.netaddr.NetworkAddressManagerServiceImpl;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class NetaddrActivator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(NetworkAddressManagerServiceImpl.class);
    private static BundleContext bundleContext = null;
    private NetworkAddressManagerServiceImpl networkAMS = null;
    private static ConfigurationService configurationService = null;
    private static PacketLoggingService packetLoggingService = null;

    public void start(BundleContext bundleContext) throws Exception {
        try {
            logger.logEntry();
            NetaddrActivator.bundleContext = bundleContext;
            this.networkAMS = new NetworkAddressManagerServiceImpl();
            this.networkAMS.start();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Network Address Manager         ...[  STARTED ]");
            }
            bundleContext.registerService(NetworkAddressManagerService.class.getName(), (Object)this.networkAMS, null);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Network Address Manager Service ...[REGISTERED]");
            }
        }
        finally {
            logger.logExit();
        }
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    public static PacketLoggingService getPacketLogging() {
        if (packetLoggingService == null) {
            packetLoggingService = (PacketLoggingService)ServiceUtils.getService((BundleContext)bundleContext, PacketLoggingService.class);
        }
        return packetLoggingService;
    }

    public void stop(BundleContext bundleContext) {
        if (this.networkAMS != null) {
            this.networkAMS.stop();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Network Address Manager Service ...[STOPPED]");
        }
        configurationService = null;
        packetLoggingService = null;
    }

    static BundleContext getBundleContext() {
        return bundleContext;
    }
}

