/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCacheEntry;

public class FeedbackCache {
    final Map<Integer, FeedbackCacheEntry> cache = new ConcurrentHashMap<Integer, FeedbackCacheEntry>();

    public int size() {
        return this.cache.size();
    }

    public Set<Map.Entry<Integer, FeedbackCacheEntry>> entrySet() {
        return this.cache.entrySet();
    }

    public void update(Integer ssrc, RTCPReportBlock[] reports, RTCPREMBPacket remb) {
        if (ssrc != 0 && (reports != null && reports.length != 0 || remb != null)) {
            long lastUpdate = System.currentTimeMillis();
            FeedbackCacheEntry item = new FeedbackCacheEntry();
            item.reports = reports;
            item.remb = remb;
            item.lastUpdate = lastUpdate;
            if ((reports == null || reports.length == 0 || remb == null) && this.cache.containsKey(ssrc)) {
                FeedbackCacheEntry base = this.cache.get(ssrc);
                if (base != null && (reports == null || reports.length == 0)) {
                    item.reports = base.reports;
                }
                if (base != null && remb == null) {
                    item.remb = base.remb;
                }
            }
            this.cache.put(ssrc, item);
        }
    }
}

