/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Event;
import com.voxeo.utils.EventDispatcher;
import com.voxeo.utils.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Holder<T> {
    private T data;
    private EventDispatcher listenerManager = new EventDispatcher();

    public T get() {
        return this.data;
    }

    public void set(T data) {
        T oldData = this.data;
        this.data = data;
        this.fire(new HolderEvent(oldData, this.data));
    }

    public void clear() {
        T oldData = this.data;
        this.data = null;
        if (oldData != null) {
            this.fire(new HolderEvent(oldData, this.data));
        }
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void addListener(EventListener<HolderEvent> listener) {
        this.listenerManager.addListener(new HolderEvent(null, null).getClass(), listener);
    }

    public void removeListener(EventListener<HolderEvent> listener) {
        this.listenerManager.removeListener(listener);
    }

    protected void fire(HolderEvent holderEvent) {
        this.listenerManager.fire(holderEvent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HolderEvent
    extends Event<Holder<T>> {
        public final T oldData;
        public final T newData;

        public HolderEvent(T oldData, T newData) {
            super(Holder.this);
            this.oldData = oldData;
            this.newData = newData;
        }
    }
}

