/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.ascii.SocketTextReader;
import com.hazelcast.nio.tcp.AbstractSelectionHandler;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SocketClientDataReader;
import com.hazelcast.nio.tcp.SocketPacketReader;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

final class ReadHandler
extends AbstractSelectionHandler
implements Runnable {
    private final ByteBuffer buffer;
    private final IOSelector ioSelector;
    private SocketReader socketReader;
    private volatile long lastHandle;

    public ReadHandler(TcpIpConnection connection, IOSelector ioSelector) {
        super(connection);
        this.ioSelector = ioSelector;
        this.buffer = ByteBuffer.allocate(this.connectionManager.socketReceiveBufferSize);
    }

    @Override
    public void handle() {
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.live()) {
            String message = "We are being asked to read, but connection is not live so we won't";
            this.logger.finest(message);
            return;
        }
        try {
            int readBytes;
            if (this.socketReader == null) {
                this.initializeSocketReader();
                if (this.socketReader == null) {
                    return;
                }
            }
            if ((readBytes = this.socketChannel.read(this.buffer)) == -1) {
                throw new EOFException("Remote socket closed!");
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.buffer.position() == 0) {
                return;
            }
            this.buffer.flip();
            this.socketReader.read(this.buffer);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
        }
        catch (Throwable t) {
            this.handleSocketException(t);
        }
    }

    private void initializeSocketReader() throws IOException {
        if (this.socketReader == null) {
            ByteBuffer protocolBuffer = ByteBuffer.allocate(3);
            int readBytes = this.socketChannel.read(protocolBuffer);
            if (readBytes == -1) {
                throw new EOFException("Could not read protocol type!");
            }
            if (readBytes == 0 && this.connectionManager.isSSLEnabled()) {
                return;
            }
            if (!protocolBuffer.hasRemaining()) {
                String protocol = StringUtil.bytesToString(protocolBuffer.array());
                WriteHandler writeHandler = this.connection.getWriteHandler();
                if ("HZC".equals(protocol)) {
                    this.connection.setType(ConnectionType.MEMBER);
                    writeHandler.setProtocol("HZC");
                    this.socketReader = new SocketPacketReader(this.connection);
                } else if ("CB1".equals(protocol)) {
                    writeHandler.setProtocol("CB1");
                    this.socketReader = new SocketClientDataReader(this.connection);
                } else {
                    writeHandler.setProtocol("TXT");
                    this.buffer.put(protocolBuffer.array());
                    this.socketReader = new SocketTextReader(this.connection);
                    this.connection.getConnectionManager().incrementTextConnections();
                }
            }
            if (this.socketReader == null) {
                throw new IOException("Could not initialize SocketReader!");
            }
        }
    }

    @Override
    public void run() {
        this.registerOp(this.ioSelector.getSelector(), 1);
    }

    long getLastHandle() {
        return this.lastHandle;
    }

    public void register() {
        this.ioSelector.addTask(this);
        this.ioSelector.wakeup();
    }

    void shutdown() {
        this.ioSelector.addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadHandler.this.socketChannel.closeInbound();
                }
                catch (IOException e) {
                    ReadHandler.this.logger.finest("Error while closing inbound", e);
                }
            }
        });
        this.ioSelector.wakeup();
    }
}

