/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.operation.GetAllOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MapGetAllOperationFactory
implements OperationFactory {
    String name;
    Set<Data> keys = new HashSet<Data>();

    public MapGetAllOperationFactory() {
    }

    public MapGetAllOperationFactory(String name, Set<Data> keys) {
        this.name = name;
        this.keys = keys;
    }

    @Override
    public Operation createOperation() {
        return new GetAllOperation(this.name, this.keys);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            key.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.keys.add(data);
        }
    }
}

