/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.DataSerializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;

abstract class AbstractCacheConfig<K, V>
implements CompleteConfiguration<K, V>,
DataSerializable {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int MAX_BACKUP_COUNT = 6;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.RANDOM;
    protected Set<CacheEntryListenerConfiguration<K, V>> listenerConfigurations;
    protected Class<K> keyType;
    protected Class<V> valueType;
    protected Factory<CacheLoader<K, V>> cacheLoaderFactory;
    protected Factory<CacheWriter<? super K, ? super V>> cacheWriterFactory;
    protected Factory<ExpiryPolicy> expiryPolicyFactory;
    protected boolean isReadThrough;
    protected boolean isWriteThrough;
    protected boolean isStatisticsEnabled;
    protected boolean isStoreByValue;
    protected boolean isManagementEnabled;

    public AbstractCacheConfig() {
        this.keyType = Object.class;
        this.valueType = Object.class;
        this.listenerConfigurations = this.createConcurrentSet();
        this.cacheLoaderFactory = null;
        this.cacheWriterFactory = null;
        this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
        this.isReadThrough = false;
        this.isWriteThrough = false;
        this.isStatisticsEnabled = false;
        this.isStoreByValue = true;
        this.isManagementEnabled = false;
    }

    public AbstractCacheConfig(CompleteConfiguration<K, V> configuration) {
        this.keyType = configuration.getKeyType();
        this.valueType = configuration.getValueType();
        this.listenerConfigurations = this.createConcurrentSet();
        for (CacheEntryListenerConfiguration listenerConf : configuration.getCacheEntryListenerConfigurations()) {
            this.listenerConfigurations.add(listenerConf);
        }
        this.cacheLoaderFactory = configuration.getCacheLoaderFactory();
        this.cacheWriterFactory = configuration.getCacheWriterFactory();
        Factory factory = configuration.getExpiryPolicyFactory();
        this.expiryPolicyFactory = factory == null ? EternalExpiryPolicy.factoryOf() : factory;
        this.isReadThrough = configuration.isReadThrough();
        this.isWriteThrough = configuration.isWriteThrough();
        this.isStatisticsEnabled = configuration.isStatisticsEnabled();
        this.isStoreByValue = configuration.isStoreByValue();
        this.isManagementEnabled = configuration.isManagementEnabled();
    }

    public CompleteConfiguration<K, V> addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        if (!this.listenerConfigurations.add(cacheEntryListenerConfiguration)) {
            throw new IllegalArgumentException("A CacheEntryListenerConfiguration can be registered only once");
        }
        return this;
    }

    public CompleteConfiguration<K, V> removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        this.listenerConfigurations.remove(cacheEntryListenerConfiguration);
        return this;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return this.listenerConfigurations;
    }

    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public CompleteConfiguration<K, V> setStatisticsEnabled(boolean enabled) {
        this.isStatisticsEnabled = enabled;
        return this;
    }

    public boolean isManagementEnabled() {
        return this.isManagementEnabled;
    }

    public CompleteConfiguration<K, V> setManagementEnabled(boolean enabled) {
        this.isManagementEnabled = enabled;
        return this;
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    public Class<V> getValueType() {
        return this.valueType;
    }

    public CompleteConfiguration<K, V> setTypes(Class<K> keyType, Class<V> valueType) {
        if (keyType == null || valueType == null) {
            throw new NullPointerException("keyType and/or valueType can't be null");
        }
        this.keyType = keyType;
        this.valueType = valueType;
        return this;
    }

    public boolean isStoreByValue() {
        return this.isStoreByValue;
    }

    public CompleteConfiguration<K, V> setStoreByValue(boolean storeByValue) {
        this.isStoreByValue = storeByValue;
        return this;
    }

    protected Set<CacheEntryListenerConfiguration<K, V>> createConcurrentSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public int hashCode() {
        int result = this.cacheLoaderFactory != null ? this.cacheLoaderFactory.hashCode() : 0;
        result = 31 * result + this.listenerConfigurations.hashCode();
        result = 31 * result + this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        result = 31 * result + (this.cacheWriterFactory != null ? this.cacheWriterFactory.hashCode() : 0);
        result = 31 * result + (this.expiryPolicyFactory != null ? this.expiryPolicyFactory.hashCode() : 0);
        result = 31 * result + (this.isReadThrough ? 1 : 0);
        result = 31 * result + (this.isWriteThrough ? 1 : 0);
        result = 31 * result + (this.isStatisticsEnabled ? 1 : 0);
        result = 31 * result + (this.isStoreByValue ? 1 : 0);
        result = 31 * result + (this.isManagementEnabled ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCacheConfig that = (AbstractCacheConfig)o;
        if (this.isManagementEnabled != that.isManagementEnabled) {
            return false;
        }
        if (this.isReadThrough != that.isReadThrough) {
            return false;
        }
        if (this.isStatisticsEnabled != that.isStatisticsEnabled) {
            return false;
        }
        if (this.isStoreByValue != that.isStoreByValue) {
            return false;
        }
        if (this.isWriteThrough != that.isWriteThrough) {
            return false;
        }
        if (this.cacheLoaderFactory != null ? !this.cacheLoaderFactory.equals(that.cacheLoaderFactory) : that.cacheLoaderFactory != null) {
            return false;
        }
        if (this.cacheWriterFactory != null ? !this.cacheWriterFactory.equals(that.cacheWriterFactory) : that.cacheWriterFactory != null) {
            return false;
        }
        if (this.expiryPolicyFactory != null ? !this.expiryPolicyFactory.equals(that.expiryPolicyFactory) : that.expiryPolicyFactory != null) {
            return false;
        }
        if (!this.keyType.equals(that.keyType)) {
            return false;
        }
        if (!this.listenerConfigurations.equals(that.listenerConfigurations)) {
            return false;
        }
        return this.valueType.equals(that.valueType);
    }
}

