/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.HazelcastCacheManager;
import com.hazelcast.cache.impl.HazelcastCachingProvider;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public abstract class HazelcastAbstractCachingProvider
implements CachingProvider {
    protected static final ILogger LOGGER = Logger.getLogger(HazelcastCachingProvider.class);
    protected static volatile HazelcastInstance hazelcastInstance;
    protected final ClassLoader defaultClassLoader;
    protected final URI defaultURI;
    private final Map<ClassLoader, Map<URI, HazelcastCacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, HazelcastCacheManager>>();

    public HazelcastAbstractCachingProvider() {
        this.defaultClassLoader = this.getClass().getClassLoader();
        try {
            this.defaultURI = new URI("hazelcast");
        }
        catch (URISyntaxException e) {
            throw new CacheException("Cannot create Default URI", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI managerURI = this.getManagerUri(uri);
        ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
        Properties managerProperties = properties == null ? new Properties() : properties;
        Map<ClassLoader, Map<URI, HazelcastCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            HazelcastCacheManager cacheManager;
            Map<URI, HazelcastCacheManager> cacheManagersByURI = this.cacheManagers.get(managerClassLoader);
            if (cacheManagersByURI == null) {
                cacheManagersByURI = new HashMap<URI, HazelcastCacheManager>();
                this.cacheManagers.put(managerClassLoader, cacheManagersByURI);
            }
            if ((cacheManager = cacheManagersByURI.get(managerURI)) == null || cacheManager.isClosed()) {
                try {
                    cacheManager = this.createHazelcastCacheManager(uri, classLoader, managerProperties);
                    cacheManagersByURI.put(managerURI, cacheManager);
                }
                catch (Exception e) {
                    throw new CacheException("Error opening URI" + managerURI.toString(), (Throwable)e);
                }
            }
            return cacheManager;
        }
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public URI getDefaultURI() {
        return this.defaultURI;
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, HazelcastCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map<URI, HazelcastCacheManager> cacheManagersByURI : this.cacheManagers.values()) {
                for (HazelcastCacheManager cacheManager : cacheManagersByURI.values()) {
                    if (cacheManager.isDefaultClassLoader) {
                        cacheManager.close();
                        continue;
                    }
                    cacheManager.destroy();
                }
            }
        }
        this.cacheManagers.clear();
        this.shutdownHazelcastInstance();
    }

    protected void shutdownHazelcastInstance() {
        HazelcastInstance localInstanceRef = hazelcastInstance;
        if (localInstanceRef != null) {
            localInstanceRef.shutdown();
        }
        hazelcastInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
        Map<ClassLoader, Map<URI, HazelcastCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Map<URI, HazelcastCacheManager> cacheManagersByURI = this.cacheManagers.get(managerClassLoader);
            if (cacheManagersByURI != null) {
                for (CacheManager cacheManager : cacheManagersByURI.values()) {
                    cacheManager.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        URI managerURI = this.getManagerUri(uri);
        ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
        Map<ClassLoader, Map<URI, HazelcastCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Map<URI, HazelcastCacheManager> cacheManagersByURI = this.cacheManagers.get(managerClassLoader);
            if (cacheManagersByURI != null) {
                CacheManager cacheManager = cacheManagersByURI.remove(managerURI);
                if (cacheManager != null) {
                    cacheManager.close();
                }
                if (cacheManagersByURI.isEmpty()) {
                    this.cacheManagers.remove(classLoader);
                }
            }
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return false;
            }
        }
        return false;
    }

    protected URI getManagerUri(URI uri) {
        return uri == null ? this.defaultURI : uri;
    }

    protected ClassLoader getManagerClassLoader(ClassLoader classLoader) {
        return classLoader == null ? this.defaultClassLoader : classLoader;
    }

    protected abstract HazelcastCacheManager createHazelcastCacheManager(URI var1, ClassLoader var2, Properties var3);
}

