/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ContainsSelector
extends BaseExtendSelector {
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";
    private String contains;
    private boolean casesensitive;
    private boolean ignorewhitespace;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{containsselector text: ");
        stringBuffer.append(this.contains);
        stringBuffer.append(" casesensitive: ");
        if (this.casesensitive) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(" ignorewhitespace: ");
        if (this.ignorewhitespace) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setText(String string) {
        this.contains = string;
    }

    public void setCasesensitive(boolean bl) {
        this.casesensitive = bl;
    }

    public void setIgnorewhitespace(boolean bl) {
        this.ignorewhitespace = bl;
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(string)) {
                    this.setText(parameterArray[n].getValue());
                } else if (CASE_KEY.equalsIgnoreCase(string)) {
                    this.setCasesensitive(Project.toBoolean(parameterArray[n].getValue()));
                } else if (WHITESPACE_KEY.equalsIgnoreCase(string)) {
                    this.setIgnorewhitespace(Project.toBoolean(parameterArray[n].getValue()));
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(File file, String string, File file2) {
        boolean bl;
        BufferedReader bufferedReader;
        block16: {
            boolean bl2;
            this.validate();
            if (file2.isDirectory()) {
                return true;
            }
            String string2 = this.contains;
            if (!this.casesensitive) {
                string2 = this.contains.toLowerCase();
            }
            if (this.ignorewhitespace) {
                string2 = SelectorUtils.removeWhitespace(string2);
            }
            bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                    String string3 = bufferedReader.readLine();
                    while (true) {
                        if (string3 == null) {
                            bl = false;
                            break block16;
                        }
                        if (!this.casesensitive) {
                            string3 = string3.toLowerCase();
                        }
                        if (this.ignorewhitespace) {
                            string3 = SelectorUtils.removeWhitespace(string3);
                        }
                        if (string3.indexOf(string2) > -1) {
                            bl2 = true;
                            Object var7_10 = null;
                            if (bufferedReader == null) return bl2;
                            break;
                        }
                        string3 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("Could not read file " + string);
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new BuildException("Could not close file " + string);
                }
            }
            try {}
            catch (Exception exception) {
                throw new BuildException("Could not close file " + string);
            }
            bufferedReader.close();
            return bl2;
        }
        Object var7_11 = null;
        if (bufferedReader == null) return bl;
        try {}
        catch (Exception exception) {
            throw new BuildException("Could not close file " + string);
        }
        bufferedReader.close();
        return bl;
    }

    private final /* synthetic */ void this() {
        this.contains = null;
        this.casesensitive = true;
        this.ignorewhitespace = false;
    }

    public ContainsSelector() {
        this.this();
    }
}

