/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import javax.swing.table.AbstractTableModel;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.InspectorModel;
import org.jrobin.inspector.Util;

class DatasourceTableModel
extends AbstractTableModel {
    private static final Object[] DESCRIPTIONS = new Object[]{"name", "type", "heartbeat", "min value", "max value", "last value", "accum. value", "NaN seconds"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private File file;
    private Object[] values;
    private int dsIndex = -1;

    DatasourceTableModel() {
    }

    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return DESCRIPTIONS[n];
        }
        if (n2 == 1) {
            if (this.values != null) {
                return this.values[n];
            }
            return "--";
        }
        return null;
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    void setFile(File file) {
        this.file = file;
        this.setIndex(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndex(int n) {
        if (this.dsIndex != n) {
            this.dsIndex = n;
            this.values = null;
            if (this.dsIndex >= 0) {
                try {
                    RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Datasource datasource = rrdDb.getDatasource(this.dsIndex);
                        this.values = new Object[]{datasource.getDsName(), datasource.getDsType(), "" + datasource.getHeartbeat(), InspectorModel.formatDouble(datasource.getMinValue()), InspectorModel.formatDouble(datasource.getMaxValue()), InspectorModel.formatDouble(datasource.getLastValue()), InspectorModel.formatDouble(datasource.getAccumValue()), "" + datasource.getNanSeconds()};
                    }
                    finally {
                        rrdDb.close();
                    }
                }
                catch (IOException iOException) {
                    Util.error(null, iOException);
                }
                catch (RrdException rrdException) {
                    Util.error(null, rrdException);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

