/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Aggregates;
import org.jrobin.data.CDef;
import org.jrobin.data.Def;
import org.jrobin.data.Normalizer;
import org.jrobin.data.PDef;
import org.jrobin.data.Plottable;
import org.jrobin.data.RpnCalculator;
import org.jrobin.data.SDef;
import org.jrobin.data.Source;

public class DataProcessor
implements ConsolFuns {
    public static final int DEFAULT_PIXEL_COUNT = 600;
    private static final double DEFAULT_PERCENTILE = 95.0;
    private int pixelCount = 600;
    public static final boolean DEFAULT_POOL_USAGE_POLICY = false;
    private boolean poolUsed = false;
    private final long tStart;
    private long tEnd;
    private long[] timestamps;
    private long lastRrdArchiveUpdateTime = 0L;
    private long step = 0L;
    private long fetchRequestResolution = 1L;
    private Map<String, Source> sources = new LinkedHashMap<String, Source>();
    private Def[] defSources;

    public DataProcessor(long l, long l2) throws RrdException {
        if (!(l < l2 && l > 0L && l2 > 0L || l > 0L && l2 == 0L)) {
            throw new RrdException("Invalid timestamps specified: " + l + ", " + l2);
        }
        this.tStart = l;
        this.tEnd = l2;
    }

    public DataProcessor(Date date, Date date2) throws RrdException {
        this(Util.getTimestamp(date), date2 != null ? Util.getTimestamp(date2) : 0L);
    }

    public DataProcessor(Calendar calendar, Calendar calendar2) throws RrdException {
        this(Util.getTimestamp(calendar), calendar2 != null ? Util.getTimestamp(calendar2) : 0L);
    }

    public boolean isPoolUsed() {
        return this.poolUsed;
    }

    public void setPoolUsed(boolean bl) {
        this.poolUsed = bl;
    }

    public void setPixelCount(int n) {
        this.pixelCount = n;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }

    public void setStep(long l) {
        this.step = l;
    }

    public long getStep() {
        return this.step;
    }

    public long getFetchRequestResolution() {
        return this.fetchRequestResolution;
    }

    public void setFetchRequestResolution(long l) {
        this.fetchRequestResolution = l;
    }

    public long getEndingTimestamp() {
        return this.tEnd;
    }

    public long[] getTimestamps() throws RrdException {
        if (this.timestamps == null) {
            throw new RrdException("Timestamps not calculated yet");
        }
        return this.timestamps;
    }

    public double[] getValues(String string) throws RrdException {
        Source source = this.getSource(string);
        double[] dArray = source.getValues();
        if (dArray == null) {
            throw new RrdException("Values not available for source [" + string + "]");
        }
        return dArray;
    }

    public double getAggregate(String string, String string2) throws RrdException {
        Source source = this.getSource(string);
        return source.getAggregates(this.tStart, this.tEnd).getAggregate(string2);
    }

    public Aggregates getAggregates(String string) throws RrdException {
        Source source = this.getSource(string);
        return source.getAggregates(this.tStart, this.tEnd);
    }

    public double get95Percentile(String string) throws RrdException {
        return this.getPercentile(string);
    }

    public double getPercentile(String string) throws RrdException {
        return this.getPercentile(string, 95.0);
    }

    public double getPercentile(String string, double d) throws RrdException {
        if (d <= 0.0 || d > 100.0) {
            throw new RrdException("Invalid percentile [" + d + "], should be between 0 and 100");
        }
        Source source = this.getSource(string);
        return source.getPercentile(this.tStart, this.tEnd, d);
    }

    public String[] getSourceNames() {
        return this.sources.keySet().toArray(new String[0]);
    }

    public double[][] getValues() throws RrdException {
        String[] stringArray = this.getSourceNames();
        double[][] dArrayArray = new double[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            dArrayArray[i] = this.getValues(stringArray[i]);
        }
        return dArrayArray;
    }

    private Source getSource(String string) throws RrdException {
        Source source = this.sources.get(string);
        if (source != null) {
            return source;
        }
        throw new RrdException("Unknown source: " + string);
    }

    public void addDatasource(String string, Plottable plottable) {
        PDef pDef = new PDef(string, plottable);
        this.sources.put(string, pDef);
    }

    public void addDatasource(String string, String string2) {
        CDef cDef = new CDef(string, string2);
        this.sources.put(string, cDef);
    }

    public void addDatasource(String string, String string2, String string3) {
        SDef sDef = new SDef(string, string2, string3);
        this.sources.put(string, sDef);
    }

    public void addDatasource(String string, String string2, String string3, String string4) {
        Def def = new Def(string, string2, string3, string4);
        this.sources.put(string, def);
    }

    public void addDatasource(String string, String string2, String string3, String string4, String string5) {
        Def def = new Def(string, string2, string3, string4, string5);
        this.sources.put(string, def);
    }

    public void addDatasource(String string, FetchData fetchData) {
        Def def = new Def(string, fetchData);
        this.sources.put(string, def);
    }

    public void processData() throws IOException, RrdException {
        this.extractDefs();
        this.fetchRrdData();
        this.fixZeroEndingTimestamp();
        this.chooseOptimalStep();
        this.createTimestamps();
        this.assignTimestampsToSources();
        this.normalizeRrdValues();
        this.calculateNonRrdSources();
    }

    public double[] getValuesPerPixel(String string, int n) throws RrdException {
        this.setPixelCount(n);
        return this.getValuesPerPixel(string);
    }

    public double[] getValuesPerPixel(String string) throws RrdException {
        double[] dArray = this.getValues(string);
        double[] dArray2 = new double[this.pixelCount];
        Arrays.fill(dArray2, Double.NaN);
        long l = this.tEnd - this.tStart;
        int n = 0;
        block0: for (int i = 0; i < this.pixelCount; ++i) {
            double d = (double)this.tStart + (double)(l * (long)i) / (double)(this.pixelCount - 1);
            while (n < this.timestamps.length && !(d <= (double)(this.timestamps[n] - this.step))) {
                if (d <= (double)this.timestamps[n]) {
                    dArray2[i] = dArray[n];
                    continue block0;
                }
                ++n;
            }
        }
        return dArray2;
    }

    public long[] getTimestampsPerPixel(int n) {
        this.setPixelCount(n);
        return this.getTimestampsPerPixel();
    }

    public long[] getTimestampsPerPixel() {
        long[] lArray = new long[this.pixelCount];
        long l = this.tEnd - this.tStart;
        for (int i = 0; i < this.pixelCount; ++i) {
            lArray[i] = Math.round((double)this.tStart + (double)(l * (long)i) / (double)(this.pixelCount - 1));
        }
        return lArray;
    }

    public String dump() throws RrdException {
        String[] stringArray = this.getSourceNames();
        double[][] dArray = this.getValues();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DataProcessor.format("timestamp", 12));
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            stringBuffer.append(DataProcessor.format(string, 20));
        }
        stringBuffer.append("\n");
        for (int i = 0; i < this.timestamps.length; ++i) {
            stringBuffer.append(DataProcessor.format("" + this.timestamps[i], 12));
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(DataProcessor.format(Util.formatDouble(dArray[n][i]), 20));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public long getLastRrdArchiveUpdateTime() {
        return this.lastRrdArchiveUpdateTime;
    }

    private void extractDefs() {
        ArrayList<Def> arrayList = new ArrayList<Def>();
        for (Source source : this.sources.values()) {
            if (!(source instanceof Def)) continue;
            arrayList.add((Def)source);
        }
        this.defSources = arrayList.toArray(new Def[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRrdData() throws IOException, RrdException {
        long l = this.tEnd == 0L ? Util.getTime() : this.tEnd;
        for (int i = 0; i < this.defSources.length; ++i) {
            if (this.defSources[i].isLoaded()) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.defSources[i].getDsName());
            for (int j = i + 1; j < this.defSources.length; ++j) {
                if (!this.defSources[i].isCompatibleWith(this.defSources[j])) continue;
                hashSet.add(this.defSources[j].getDsName());
            }
            RrdDb rrdDb = null;
            try {
                rrdDb = this.getRrd(this.defSources[i]);
                this.lastRrdArchiveUpdateTime = Math.max(this.lastRrdArchiveUpdateTime, rrdDb.getLastArchiveUpdateTime());
                FetchRequest fetchRequest = rrdDb.createFetchRequest(this.defSources[i].getConsolFun(), this.tStart, l, this.fetchRequestResolution);
                fetchRequest.setFilter(hashSet);
                FetchData fetchData = fetchRequest.fetchData();
                this.defSources[i].setFetchData(fetchData);
                for (int j = i + 1; j < this.defSources.length; ++j) {
                    if (!this.defSources[i].isCompatibleWith(this.defSources[j])) continue;
                    this.defSources[j].setFetchData(fetchData);
                }
                continue;
            }
            finally {
                if (rrdDb != null) {
                    this.releaseRrd(rrdDb, this.defSources[i]);
                }
            }
        }
    }

    private void fixZeroEndingTimestamp() throws RrdException {
        if (this.tEnd == 0L) {
            if (this.defSources.length == 0) {
                throw new RrdException("Could not adjust zero ending timestamp, no DEF source provided");
            }
            this.tEnd = this.defSources[0].getArchiveEndTime();
            for (int i = 1; i < this.defSources.length; ++i) {
                this.tEnd = Math.min(this.tEnd, this.defSources[i].getArchiveEndTime());
            }
            if (this.tEnd <= this.tStart) {
                throw new RrdException("Could not resolve zero ending timestamp.");
            }
        }
    }

    private void chooseOptimalStep() {
        long l = Long.MAX_VALUE;
        for (Def def : this.defSources) {
            long l2;
            long l3 = l2 = def.getFetchStep();
            if (this.step > 0L) {
                l3 = Math.min(l, ((this.step - 1L) / l2 + 1L) * l2);
            }
            l = Math.min(l, l3);
        }
        this.step = l != Long.MAX_VALUE ? l : Math.max((this.tEnd - this.tStart) / (long)this.pixelCount, 1L);
    }

    private void createTimestamps() {
        long l = Util.normalize(this.tStart, this.step);
        long l2 = Util.normalize(this.tEnd, this.step);
        if (l2 < this.tEnd) {
            l2 += this.step;
        }
        int n = (int)((l2 - l) / this.step + 1L);
        this.timestamps = new long[n];
        for (int i = 0; i < n; ++i) {
            this.timestamps[i] = l;
            l += this.step;
        }
    }

    private void assignTimestampsToSources() {
        for (Source source : this.sources.values()) {
            source.setTimestamps(this.timestamps);
        }
    }

    private void normalizeRrdValues() throws RrdException {
        Normalizer normalizer = new Normalizer(this.timestamps);
        for (Def def : this.defSources) {
            long[] lArray = def.getRrdTimestamps();
            double[] dArray = def.getRrdValues();
            double[] dArray2 = normalizer.normalize(lArray, dArray);
            def.setValues(dArray2);
        }
    }

    private void calculateNonRrdSources() throws RrdException {
        for (Source source : this.sources.values()) {
            if (source instanceof SDef) {
                this.calculateSDef((SDef)source);
                continue;
            }
            if (source instanceof CDef) {
                this.calculateCDef((CDef)source);
                continue;
            }
            if (!(source instanceof PDef)) continue;
            this.calculatePDef((PDef)source);
        }
    }

    private void calculatePDef(PDef pDef) {
        pDef.calculateValues();
    }

    private void calculateCDef(CDef cDef) throws RrdException {
        RpnCalculator rpnCalculator = new RpnCalculator(cDef.getRpnExpression(), cDef.getName(), this);
        cDef.setValues(rpnCalculator.calculateValues());
    }

    private void calculateSDef(SDef sDef) throws RrdException {
        String string = sDef.getDefName();
        String string2 = sDef.getConsolFun();
        Source source = this.getSource(string);
        double d = source.getAggregates(this.tStart, this.tEnd).getAggregate(string2);
        sDef.setValue(d);
    }

    private RrdDb getRrd(Def def) throws IOException, RrdException {
        String string = def.getPath();
        String string2 = def.getBackend();
        if (this.poolUsed && string2 == null) {
            return RrdDbPool.getInstance().requestRrdDb(string);
        }
        if (string2 != null) {
            return new RrdDb(string, true, RrdBackendFactory.getFactory(string2));
        }
        return new RrdDb(string, true);
    }

    private void releaseRrd(RrdDb rrdDb, Def def) throws IOException, RrdException {
        String string = def.getBackend();
        if (this.poolUsed && string == null) {
            RrdDbPool.getInstance().release(rrdDb);
        } else {
            rrdDb.close();
        }
    }

    private static String format(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws IOException, RrdException {
        long l = Util.getTimestamp(2003, 4, 1);
        long l2 = Util.getTimestamp(2003, 5, 1);
        System.out.println("t1 = " + l);
        System.out.println("t2 = " + l2);
        String string = Util.getJRobinDemoPath("demo.rrd");
        DataProcessor dataProcessor = new DataProcessor(l, l2);
        dataProcessor.addDatasource("X", string, "sun", "AVERAGE");
        dataProcessor.addDatasource("Y", string, "shade", "AVERAGE");
        dataProcessor.addDatasource("Z", "X,Y,+,2,/");
        dataProcessor.addDatasource("DERIVE[Z]", "Z,PREV(Z),-,STEP,/");
        dataProcessor.addDatasource("TREND[Z]", "DERIVE[Z],SIGN");
        dataProcessor.addDatasource("AVG[Z]", "Z", "AVERAGE");
        dataProcessor.addDatasource("DELTA", "Z,AVG[Z],-");
        long l3 = System.currentTimeMillis();
        dataProcessor.processData();
        System.out.println("Data processed in " + (System.currentTimeMillis() - l3) + " milliseconds\n---");
        System.out.println(dataProcessor.dump());
        System.out.println("\nAggregates for X");
        Aggregates aggregates = dataProcessor.getAggregates("X");
        System.out.println(aggregates.dump());
        System.out.println("\nAggregates for Y");
        aggregates = dataProcessor.getAggregates("Y");
        System.out.println(aggregates.dump());
        System.out.println("\n95-percentile for X: " + Util.formatDouble(dataProcessor.get95Percentile("X")));
        System.out.println("95-percentile for Y: " + Util.formatDouble(dataProcessor.get95Percentile("Y")));
        System.out.println("\nLast archive update time was: " + dataProcessor.getLastRrdArchiveUpdateTime());
    }
}

