/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdDefTemplate
extends XmlTemplate {
    public RrdDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdDefTemplate(String string) throws IOException, RrdException {
        super(string);
    }

    public RrdDefTemplate(File file) throws IOException, RrdException {
        super(file);
    }

    public RrdDef getRrdDef() throws RrdException {
        String string;
        Node[] nodeArray;
        Node[] nodeArray2;
        if (!this.root.getTagName().equals("rrd_def")) {
            throw new RrdException("XML definition must start with <rrd_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"path", "start", "step", "datasource*", "archive*"});
        String string2 = this.getChildValue(this.root, "path");
        RrdDef rrdDef = new RrdDef(string2);
        try {
            String string3 = this.getChildValue(this.root, "start");
            nodeArray2 = Util.getCalendar(string3);
            rrdDef.setStartTime((Calendar)nodeArray2);
        }
        catch (RrdException rrdException) {
            // empty catch block
        }
        try {
            long l = this.getChildValueAsLong(this.root, "step");
            rrdDef.setStep(l);
        }
        catch (RrdException rrdException) {
            // empty catch block
        }
        nodeArray2 = nodeArray = RrdDefTemplate.getChildNodes(this.root, "datasource");
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray2[i];
            this.validateTagsOnlyOnce(node, new String[]{"name", "type", "heartbeat", "min", "max"});
            String object = this.getChildValue(node, "name");
            string = this.getChildValue(node, "type");
            long l = this.getChildValueAsLong(node, "heartbeat");
            double d = this.getChildValueAsDouble(node, "min");
            double d2 = this.getChildValueAsDouble(node, "max");
            rrdDef.addDatasource(object, string, l, d, d2);
        }
        for (Node node : nodeArray2 = RrdDefTemplate.getChildNodes(this.root, "archive")) {
            this.validateTagsOnlyOnce(node, new String[]{"cf", "xff", "steps", "rows"});
            string = this.getChildValue(node, "cf");
            double d = this.getChildValueAsDouble(node, "xff");
            int n2 = this.getChildValueAsInt(node, "steps");
            int n3 = this.getChildValueAsInt(node, "rows");
            rrdDef.addArchive(string, d, n2, n3);
        }
        return rrdDef;
    }
}

