/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;

class Table {
    static final int SYSTEM_TABLE = 0;
    static final int TEMP_TABLE = 1;
    static final int MEMORY_TABLE = 2;
    static final int CACHED_TABLE = 3;
    static final int TEMP_TEXT_TABLE = 4;
    static final int TEXT_TABLE = 5;
    static final int VIEW = 6;
    static final String DEFAULT_PK = "";
    private Vector vColumn;
    private Vector vIndex;
    private int[] iPrimaryKey;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    Vector vConstraint;
    Vector[] vTrigs;
    private int[] colTypes;
    private boolean isSystem;
    private boolean isText;
    private boolean isView;
    protected int iColumnCount;
    protected int iVisibleColumns;
    protected Database dDatabase;
    protected Cache cCache;
    protected HsqlName tableName;
    protected int tableType;
    protected Session ownerSession;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;

    Table(Database database, HsqlName hsqlName, int n, Session session) throws SQLException {
        this.dDatabase = database;
        if (n == 0) {
            this.isTemp = true;
        } else if (n == 1) {
            Trace.doAssert(session != null);
            this.isTemp = true;
            this.ownerSession = session;
        } else if (n == 3) {
            this.cCache = database.logger.getCache();
            if (this.cCache != null) {
                this.isCached = true;
            } else {
                n = 2;
            }
        } else if (n == 4) {
            Trace.doAssert(session != null);
            if (!database.logger.hasLog()) {
                throw Trace.error(63);
            }
            this.isTemp = true;
            this.isText = true;
            this.isReadOnly = true;
            this.isCached = true;
            this.ownerSession = session;
        } else if (n == 5) {
            if (!database.logger.hasLog()) {
                throw Trace.error(63);
            }
            this.isText = true;
            this.isCached = true;
        } else if (n == 6) {
            this.isView = true;
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.iPrimaryKey = null;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
        this.vTrigs = new Vector[TriggerDef.numTrigs()];
        int n2 = 0;
        while (n2 < TriggerDef.numTrigs()) {
            this.vTrigs[n2] = new Vector();
            ++n2;
        }
    }

    boolean equals(String string, Session session) {
        if (this.isTemp && session.getId() != this.ownerSession.getId()) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    final boolean isText() {
        return this.isText;
    }

    final boolean isTemp() {
        return this.isTemp;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void setDataReadOnly(boolean bl) throws SQLException {
        this.isReadOnly = bl;
    }

    Session getOwnerSession() {
        return this.ownerSession;
    }

    protected void setDataSource(String string, boolean bl, Session session) throws SQLException {
        throw Trace.error(22);
    }

    protected String getDataSource() throws SQLException {
        return null;
    }

    protected boolean isDescDataSource() throws SQLException {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.vConstraint.addElement(constraint);
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    Index getConstraintIndexForColumns(int[] nArray, boolean bl) {
        Index index = this.getPrimaryIndex();
        if (ArrayUtil.haveEquality(index.getColumns(), nArray, nArray.length, bl)) {
            return index;
        }
        int n = 0;
        while (n < this.vConstraint.size()) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
            index = constraint.getMainIndex();
            if (ArrayUtil.haveEquality(index.getColumns(), nArray, nArray.length, bl)) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = n;
        while (n3 < this.vConstraint.size()) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n3);
            if (constraint.getType() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void addColumn(String string, int n) throws SQLException {
        Column column = new Column(new HsqlName(string, false), true, n, 0, 0, false, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws SQLException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4, 16, column.columnName.name);
            Trace.check(this.iIdentityColumn == -1, 24, column.columnName.name);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.doAssert(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.addElement(column);
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        int n = 0;
        while (n < result.getColumnCount()) {
            Column column = new Column(new HsqlName(result.sLabel[n], result.isLabelQuoted[n]), true, result.colType[n], result.colSize[n], result.colScale[n], false, false, null);
            this.addColumn(column);
            ++n;
        }
    }

    HsqlName getName() {
        return this.tableName;
    }

    void setName(String string, boolean bl) {
        this.tableName.rename(string, bl);
        if (HsqlName.isReservedName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    protected Table duplicate() throws SQLException {
        Table table = new Table(this.dDatabase, this.tableName, this.tableType, this.ownerSession);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws SQLException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= this.iColumnCount || nArray2[n] >= table.iColumnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[n]).getType() != table.getColumn(nArray2[n]).getType()) {
                throw Trace.error(57);
            }
            ++n;
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws SQLException {
        int[] nArray;
        Table table = this.duplicate();
        int n3 = 0;
        while (n3 < this.iVisibleColumns + 1) {
            block10: {
                block8: {
                    block9: {
                        if (n3 != n) break block8;
                        if (n2 <= 0) break block9;
                        table.addColumn(column);
                        break block8;
                    }
                    if (n2 < 0) break block10;
                }
                if (n3 == this.iVisibleColumns) break;
                table.addColumn(this.getColumn(n3));
            }
            ++n3;
        }
        int[] nArray2 = nArray = this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray);
        table.vConstraint = this.vConstraint;
        int n4 = 1;
        while (n4 < this.getIndexCount()) {
            Index index;
            Index index2 = this.getIndex(n4);
            if (!(string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null)) {
                throw Trace.error(23);
            }
            ++n4;
        }
        return table;
    }

    void updateConstraints(Table table, int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < this.vConstraint.size()) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n3);
            constraint.replaceTable(table, this, n, n2);
            ++n3;
        }
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(((Column)this.vColumn.elementAt((int)n)).columnName.name)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Index getPrimaryIndex() {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int n) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            if (index.getColumns()[0] == n) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            if (ArrayUtil.haveEquality(nArray2, nArray, nArray.length, bl) && (!bl || index.isUnique())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int[] getIndexRootsArray() throws SQLException {
        int[] nArray = new int[this.iIndexCount];
        int n = 0;
        while (n < this.iIndexCount) {
            Node node = this.getIndex(n).getRoot();
            nArray[n] = node != null ? node.getKey() : -1;
            ++n;
        }
        return nArray;
    }

    String getIndexRoots() throws SQLException {
        Trace.doAssert(this.isCached, "Table.getIndexRootData");
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.iIdentityId);
        return stringBuffer.toString();
    }

    void setIndexRoots(int[] nArray) throws SQLException {
        Trace.check(this.isCached, 22);
        int n = 0;
        while (n < this.iIndexCount) {
            int n2 = nArray[n];
            CachedRow cachedRow = null;
            if (n2 != -1) {
                cachedRow = this.cCache.getRow(n2, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = ((Row)cachedRow).getNode(n);
            }
            this.getIndex(n).setRoot(node);
            ++n;
        }
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.isCached, 22);
        int[] nArray = new int[this.iIndexCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3;
            int n4 = string.indexOf(32, n);
            nArray[n2] = n3 = Integer.parseInt(string.substring(n, n4));
            n = n4 + 1;
            ++n2;
        }
        this.setIndexRoots(nArray);
        this.iIdentityId = Integer.parseInt(string.substring(n));
    }

    Index getNextIndex(Index index) {
        int n = 0;
        if (index != null) {
            while (n < this.iIndexCount && this.getIndex(n) != index) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    void createPrimaryKey() throws SQLException {
        this.createPrimaryKey(null, null);
    }

    void createPrimaryKey(HsqlName hsqlName, int[] nArray) throws SQLException {
        Object object;
        Trace.doAssert(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        if (nArray == null) {
            nArray = new int[]{this.iColumnCount};
            object = new Column(new HsqlName(DEFAULT_PK, false), false, 4, 0, 0, true, true, null);
            this.addColumn((Column)object);
        } else {
            int n = 0;
            while (n < nArray.length) {
                this.getColumn(nArray[n]).setNullable(false);
                this.getColumn(nArray[n]).setPrimaryKey(true);
                ++n;
            }
        }
        this.iPrimaryKey = nArray;
        object = hsqlName != null ? hsqlName : new HsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexPrivate(nArray, (HsqlName)object, true);
        this.colTypes = new int[this.iColumnCount];
        int n = 0;
        while (n < this.iColumnCount) {
            this.colTypes[n] = this.getColumn(n).getType();
            ++n;
        }
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws SQLException {
        int[] nArray = ArrayUtil.getAdjustedColumnArray(index.getColumns(), index.getVisibleColumns(), n, n2);
        if (nArray.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexPrivate(nArray, index.getName(), index.isUnique());
    }

    Index createIndexPrivate(int[] nArray, HsqlName hsqlName, boolean bl) throws SQLException {
        Trace.doAssert(this.iPrimaryKey != null, "createIndex");
        int n = nArray.length;
        int n2 = this.iPrimaryKey.length;
        int[] nArray2 = new int[bl ? n : n + n2];
        int[] nArray3 = new int[bl ? n : n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = this.getColumn(nArray2[n3]).getType();
            ++n3;
        }
        if (!bl) {
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n + n4] = this.iPrimaryKey[n4];
                nArray3[n + n4] = this.getColumn(this.iPrimaryKey[n4]).getType();
                ++n4;
            }
        }
        if (nArray2[0] == this.iVisibleColumns) {
            n = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl, n);
        Trace.doAssert(this.isEmpty(), "createIndex");
        this.vIndex.addElement(index);
        ++this.iIndexCount;
        return index;
    }

    void checkDropIndex(String string, Hashtable hashtable) throws SQLException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = 0;
        while (n < this.vConstraint.size()) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
            if (hashtable.get(constraint) == null) {
                if (constraint.isIndexFK(index)) {
                    throw Trace.error(50, string);
                }
                if (constraint.isIndexUnique(index)) {
                    throw Trace.error(56, string);
                }
            }
            ++n;
        }
    }

    boolean isEmpty() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    void moveData(Table table, int n, int n2) throws SQLException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3 = null;
        if (n2 > 0) {
            object2 = this.getColumn(n);
            object3 = Column.convertObject(((Column)object2).getDefaultString(), ((Column)object2).getType());
        }
        object2 = table.getPrimaryIndex();
        Object object4 = ((Index)object2).first();
        while (object4 != null) {
            object = object4.getData();
            objectArray = this.getNewRow();
            ArrayUtil.copyAdjustArray(object, objectArray, object3, n, n2);
            this.insertNoCheck(objectArray, null, false);
            object4 = ((Index)object2).next((Node)object4);
        }
        object2 = table.getPrimaryIndex();
        object4 = ((Index)object2).first();
        while (object4 != null) {
            object = ((Index)object2).next((Node)object4);
            objectArray = object4.getData();
            table.deleteNoCheck(objectArray, null, false);
            object4 = object;
        }
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        Trace.check(!this.isReadOnly, 32);
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.vConstraint.size()) {
                Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
                constraint.checkUpdate(nArray, result, result2);
                ++n;
            }
        }
    }

    void insert(Result result, Session session) throws SQLException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = record.data[n2];
                ++n2;
            }
            this.insert(objectArray, session);
            record = record.next;
        }
    }

    void insert(Object[] objectArray, Session session) throws SQLException {
        Trace.check(!this.isReadOnly, 32);
        this.fireAll(3, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.vConstraint.size()) {
                ((Constraint)this.vConstraint.elementAt(n)).checkInsert(objectArray);
                ++n;
            }
        }
        this.insertNoCheck(objectArray, session, true);
        this.fireAll(0, objectArray);
    }

    void insertNoCheck(Object[] objectArray, Session session, boolean bl) throws SQLException {
        int n = 0;
        while (n < this.iColumnCount) {
            if (objectArray[n] == null) {
                boolean bl2;
                Column column = this.getColumn(n);
                boolean bl3 = bl2 = column.isNullable() || column.isIdentity();
                if (!bl2) {
                    throw Trace.error(10);
                }
            }
            ++n;
        }
        int n2 = this.iIdentityId;
        if (this.iIdentityColumn != -1) {
            Number number = (Number)objectArray[this.iIdentityColumn];
            if (number == null) {
                objectArray[this.iIdentityColumn] = new Integer(this.iIdentityId);
            } else {
                int n3 = number.intValue();
                if (this.iIdentityId < n3) {
                    this.iIdentityId = n2 = n3;
                }
            }
        }
        Row row = Row.newRow(this, objectArray);
        n2 = this.isText ? ((CachedRow)row).iPos + ((CachedRow)row).storageSize : ++n2;
        this.indexRow(row, true);
        if (session != null) {
            session.setLastIdentity(this.iIdentityId);
            session.addTransactionInsert(this, objectArray);
        }
        this.iIdentityId = n2;
        if (bl && !this.isTemp && !this.isReadOnly && this.dDatabase.logger.hasLog()) {
            this.dDatabase.logger.writeToLog(session, this.getInsertStatement(objectArray));
        }
    }

    void fireAll(int n, Object[] objectArray) {
        if (!this.dDatabase.isReferentialIntegrity()) {
            return;
        }
        Vector vector = this.vTrigs[n];
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            TriggerDef triggerDef = (TriggerDef)vector.elementAt(n3);
            triggerDef.push(objectArray);
            ++n3;
        }
    }

    void fireAll(int n) {
        Object[] objectArray = new Object[]{new String("Statement-level")};
        this.fireAll(n, objectArray);
    }

    void addTrigger(TriggerDef triggerDef) {
        if (Trace.TRACE) {
            Trace.trace("Trigger added " + String.valueOf(triggerDef.vectorIndx));
        }
        this.vTrigs[triggerDef.vectorIndx].addElement(triggerDef);
    }

    void checkCascadeDelete(Object[] objectArray, Session session, boolean bl) throws SQLException {
        int n = 0;
        while (n < this.vConstraint.size()) {
            Node node;
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
            if (constraint.getType() == 1 && constraint.getRef() != null && (node = constraint.findFkRef(objectArray)) != null) {
                boolean bl2;
                Table table = constraint.getRef();
                boolean bl3 = bl2 = table.getNextConstraintIndex(0, 1) != -1;
                if (!bl && !bl2) {
                    return;
                }
                Index index = constraint.getRefIndex();
                int[] nArray = constraint.getMainColumns();
                Object[] objectArray2 = new Object[nArray.length];
                ArrayUtil.copyColumnValues(objectArray, nArray, objectArray2);
                Node node2 = node;
                while (index.comparePartialRowNonUnique(objectArray2, node2.getData()) == 0) {
                    Node node3 = index.next(node2);
                    if (bl2) {
                        table.checkCascadeDelete(node2.getData(), session, bl);
                    }
                    if (bl) {
                        table.deleteNoRefCheck(node2.getData(), session);
                        if (table == this) {
                            node3 = constraint.findFkRef(objectArray);
                        }
                    }
                    if (node3 == null) break;
                    node2 = node3;
                }
            }
            ++n;
        }
    }

    void delete(Object[] objectArray, Session session) throws SQLException {
        this.fireAll(10, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            this.checkCascadeDelete(objectArray, session, false);
            this.checkCascadeDelete(objectArray, session, true);
        }
        this.deleteNoCheck(objectArray, session, true);
        this.fireAll(7, objectArray);
    }

    private void deleteNoRefCheck(Object[] objectArray, Session session) throws SQLException {
        this.fireAll(10, objectArray);
        this.deleteNoCheck(objectArray, session, true);
        this.fireAll(7, objectArray);
    }

    void deleteNoCheck(Object[] objectArray, Session session, boolean bl) throws SQLException {
        int n = 1;
        while (n < this.iIndexCount) {
            this.getIndex(n).delete(objectArray, false);
            ++n;
        }
        this.getIndex(0).delete(objectArray, true);
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isReadOnly && this.dDatabase.logger.hasLog()) {
            this.dDatabase.logger.writeToLog(session, this.getDeleteStatement(objectArray));
        }
    }

    String getInsertStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.tableName.statementName);
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.iVisibleColumns) {
            stringBuffer.append(Column.createSQLString(objectArray[n], this.getColumn(n).getType()));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName().name)) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = 0;
        while (n < this.vConstraint.size()) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
            if (constraint.getName().name.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        if (n >= 0) {
            return (Constraint)this.vConstraint.elementAt(n);
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.elementAt(n);
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return (Index)this.vIndex.elementAt(n);
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.tableName.statementName);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                Column column = this.getColumn(n);
                stringBuffer.append(column.columnName.statementName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createSQLString(objectArray[n], column.getType()));
                if (n < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.iPrimaryKey.length) {
                Column column = this.getColumn(this.iPrimaryKey[n]);
                stringBuffer.append(column.columnName.statementName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createSQLString(objectArray[this.iPrimaryKey[n]], column.getType()));
                if (n < this.iPrimaryKey.length - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    Row getRow(int n) throws SQLException {
        if (this.isCached) {
            return this.cCache.getRow(n, this);
        }
        return null;
    }

    void putRow(CachedRow cachedRow) throws SQLException {
        boolean bl = false;
        if (this.cCache != null) {
            this.cCache.add(cachedRow);
        }
    }

    void removeRow(CachedRow cachedRow) throws SQLException {
        if (this.cCache != null) {
            this.cCache.free(cachedRow);
        }
    }

    void cleanUp() throws SQLException {
        if (this.cCache != null) {
            this.cCache.cleanUp();
        }
    }

    /*
     * Unable to fully structure code
     */
    void indexRow(Row var1_1, boolean var2_2) throws SQLException {
        block5: {
            if (var2_2) {
                var3_3 = 0;
                try {
                    var4_4 = null;
                    while (var3_3 < this.iIndexCount) {
                        var4_4 = var1_1.getNextNode(var4_4);
                        this.getIndex(var3_3).insert(var4_4);
                        ++var3_3;
                    }
                    break block5;
                }
                catch (SQLException var4_5) {
                    --var3_3;
                    ** while (var3_3 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    this.getIndex(var3_3).delete(var1_1.getData(), var3_3 == 0);
                    --var3_3;
                    continue;
                }
lbl17:
                // 1 sources

                throw var4_5;
            }
        }
    }
}

