/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.BufferedXMLInputStreamImpl;
import weblogic.xml.babel.stream.CanonicalInputStream;
import weblogic.xml.babel.stream.DOMInputStream;
import weblogic.xml.babel.stream.SAXInputStream;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.BufferedXMLInputStream;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.XMLInputStreamFilterBase;
import weblogic.xml.stream.util.XMLPullReader;

public class XMLInputStreamFactoryImpl
extends XMLInputStreamFactory {
    protected ElementFilter filter;
    protected boolean filterSet = false;

    public XMLInputStream wrap(XMLInputStream xMLInputStream, ElementFilter elementFilter) throws XMLStreamException {
        return new XMLInputStreamFilterBase(xMLInputStream, elementFilter);
    }

    public void setFilter(ElementFilter elementFilter) throws XMLStreamException {
        this.filter = elementFilter;
        this.filterSet = true;
    }

    public XMLInputStream newInputStream(File file) throws XMLStreamException {
        try {
            return this.newInputStream(SAXElementFactory.createInputSource(file));
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    public XMLInputStream newInputStream(InputStream inputStream) throws XMLStreamException {
        return this.newInputStream(new InputSource(inputStream));
    }

    public XMLInputStream newInputStream(Reader reader) throws XMLStreamException {
        return this.newInputStream(new InputSource(reader));
    }

    protected XMLInputStream check(XMLInputStream xMLInputStream) throws XMLStreamException {
        if (this.filterSet) {
            return this.wrap(xMLInputStream, this.filter);
        }
        return xMLInputStream;
    }

    protected XMLInputStream newInputStream(InputSource inputSource) throws XMLStreamException {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.open(inputSource);
        return this.check(xMLInputStreamBase);
    }

    public XMLInputStream newInputStream(Reader reader, ElementFilter elementFilter) throws XMLStreamException {
        return this.wrap(this.newInputStream(reader), elementFilter);
    }

    public XMLInputStream newInputStream(InputStream inputStream, ElementFilter elementFilter) throws XMLStreamException {
        return this.wrap(this.newInputStream(inputStream), elementFilter);
    }

    public XMLInputStream newInputStream(File file, ElementFilter elementFilter) throws XMLStreamException {
        return this.wrap(this.newInputStream(file), elementFilter);
    }

    public XMLInputStream newInputStream(Document document) throws XMLStreamException {
        return this.newInputStream((Node)document);
    }

    public XMLInputStream newInputStream(Node node) throws XMLStreamException {
        DOMInputStream dOMInputStream = new DOMInputStream();
        dOMInputStream.open(node);
        return this.check(dOMInputStream);
    }

    public XMLInputStream newInputStream(Document document, ElementFilter elementFilter) throws XMLStreamException {
        return this.newInputStream((Node)document, elementFilter);
    }

    public XMLInputStream newInputStream(Node node, ElementFilter elementFilter) throws XMLStreamException {
        return this.wrap(this.newInputStream(node), elementFilter);
    }

    public XMLInputStream newInputStream(XMLPullReader xMLPullReader, InputSource inputSource) throws XMLStreamException {
        SAXInputStream sAXInputStream = new SAXInputStream(xMLPullReader);
        sAXInputStream.open(inputSource);
        return this.check(sAXInputStream);
    }

    public XMLInputStream newInputStream(XMLPullReader xMLPullReader, InputSource inputSource, ElementFilter elementFilter) throws XMLStreamException {
        return this.wrap(this.newInputStream(xMLPullReader, inputSource), elementFilter);
    }

    public BufferedXMLInputStream newBufferedInputStream(XMLInputStream xMLInputStream) throws XMLStreamException {
        return new BufferedXMLInputStreamImpl(xMLInputStream);
    }

    public XMLInputStream newInputStream(XMLInputStream xMLInputStream, ElementFilter elementFilter) throws XMLStreamException {
        return this.wrap(xMLInputStream, elementFilter);
    }

    public XMLInputStream newCanonicalInputStream(XMLInputStream xMLInputStream) throws XMLStreamException {
        return new CanonicalInputStream(xMLInputStream);
    }

    public XMLInputStream newDTDAwareInputStream(InputStream inputStream) throws XMLStreamException {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openValidating(new InputSource(inputStream));
        return this.check(xMLInputStreamBase);
    }

    public XMLInputStream newDTDAwareInputStream(Reader reader) throws XMLStreamException {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openValidating(new InputSource(reader));
        return this.check(xMLInputStreamBase);
    }

    public XMLInputStream newFragmentInputStream(InputStream inputStream, Map map) throws XMLStreamException {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openFragment(new InputSource(inputStream), map);
        return this.check(xMLInputStreamBase);
    }

    public XMLInputStream newFragmentInputStream(Reader reader, Map map) throws XMLStreamException {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openFragment(new InputSource(reader), map);
        return this.check(xMLInputStreamBase);
    }
}

