/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileList
extends DataType {
    private Vector filenames;
    private File dir;

    public void setRefid(Reference reference) throws BuildException {
        if (this.dir != null || this.filenames.size() != 0) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public void setDir(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dir = file;
    }

    public File getDir(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDir(project);
        }
        return this.dir;
    }

    public void setFiles(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.filenames.addElement(stringTokenizer.nextToken());
            }
        }
    }

    public String[] getFiles(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getFiles(project);
        }
        if (this.dir == null) {
            throw new BuildException("No directory specified for filelist.");
        }
        if (this.filenames.size() == 0) {
            throw new BuildException("No files specified for filelist.");
        }
        Object[] objectArray = new String[this.filenames.size()];
        this.filenames.copyInto(objectArray);
        return objectArray;
    }

    protected FileList getRef(Project project) {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<FileList>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        if (!((object = this.getRefid().getReferencedObject(project)) instanceof FileList)) {
            String string = this.getRefid().getRefId() + " doesn't denote a filelist";
            throw new BuildException(string);
        }
        return (FileList)object;
    }

    public void addConfiguredFile(FileName fileName) {
        if (fileName.getName() == null) {
            throw new BuildException("No name specified in nested file element");
        }
        this.filenames.addElement(fileName.getName());
    }

    private final /* synthetic */ void this() {
        this.filenames = new Vector();
    }

    public FileList() {
        this.this();
    }

    protected FileList(FileList fileList) {
        this.this();
        this.dir = fileList.dir;
        this.filenames = fileList.filenames;
        this.setProject(fileList.getProject());
    }

    public static class FileName {
        private String name;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }
}

