/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Debug {
    private static final Hashtable CLASSES = new Hashtable();
    private static final Object MUTEX = new Object();
    private static boolean watchAll = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void methodCall(Object source, String method, Object[] args) {
        Object object = MUTEX;
        synchronized (object) {
            if (watchAll || CLASSES.contains(source.getClass().getName())) {
                StringBuffer mesg = new StringBuffer("\nTRACE: ");
                mesg.append(source.toString());
                mesg.append(".");
                mesg.append(method);
                mesg.append("( ");
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i] == null) {
                        mesg.append("null");
                    } else {
                        if (args[i] instanceof String) {
                            mesg.append("\"");
                        }
                        mesg.append(args[i].toString());
                        if (args[i] instanceof String) {
                            mesg.append("\"");
                        }
                    }
                    mesg.append(", ");
                }
                if (args.length > 0) {
                    if (args[args.length - 1] instanceof String) {
                        mesg.append("\"");
                    }
                    mesg.append(args[args.length - 1]);
                    if (args[args.length - 1] instanceof String) {
                        mesg.append("\"");
                    }
                }
                mesg.append(" )\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void msg(Object source, String message) {
        Object object = MUTEX;
        synchronized (object) {
            if (watchAll || CLASSES.contains(source.getClass().getName())) {
                StringBuffer mesg = new StringBuffer("\nTRACE: ");
                mesg.append(source.toString());
                mesg.append(": ");
                mesg.append(message);
                mesg.append("\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnValue(Object source, String method, Object value) {
        Object object = MUTEX;
        synchronized (object) {
            if (watchAll || CLASSES.contains(source.getClass().getName())) {
                StringBuffer mesg = new StringBuffer("\nTRACE: ");
                mesg.append(source.toString());
                mesg.append(".");
                mesg.append(method);
                mesg.append(": Returning -> ");
                if (value == null) {
                    mesg.append("null");
                } else {
                    mesg.append(value.toString());
                }
                mesg.append("\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(String classList) {
        StringTokenizer tokenizer = new StringTokenizer(classList, ":");
        Object object = MUTEX;
        synchronized (object) {
            watchAll = false;
            if (classList.equals("ALL")) {
                watchAll = true;
            } else {
                while (tokenizer.hasMoreTokens()) {
                    String className = tokenizer.nextToken().trim();
                    if (CLASSES.contains(className)) continue;
                    CLASSES.put(className, className);
                }
            }
        }
    }
}

