/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.snac.SnacRequest;

public class RateQueue {
    private static final Logger logger = Logger.getLogger("net.kano.joscar.ratelim");
    private final ConnectionQueueMgr parentMgr;
    private final LinkedList queue = new LinkedList();
    private final RateClassMonitor rateMonitor;

    RateQueue(ConnectionQueueMgr connectionQueueMgr, RateClassMonitor rateClassMonitor) {
        DefensiveTools.checkNull(connectionQueueMgr, "parentMgr");
        DefensiveTools.checkNull(rateClassMonitor, "monitor");
        this.parentMgr = connectionQueueMgr;
        this.rateMonitor = rateClassMonitor;
    }

    public ConnectionQueueMgr getParentMgr() {
        return this.parentMgr;
    }

    public RateClassMonitor getRateClassMonitor() {
        return this.rateMonitor;
    }

    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    public synchronized boolean hasRequests() {
        return !this.queue.isEmpty();
    }

    synchronized void enqueue(SnacRequest snacRequest) {
        DefensiveTools.checkNull(snacRequest, "req");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Enqueuing " + snacRequest.getCommand() + " within ratequeue " + "(class " + this.rateMonitor.getRateInfo().getRateClass() + ")...");
        }
        this.queue.add(snacRequest);
    }

    synchronized SnacRequest dequeue() {
        if (this.queue.isEmpty()) {
            return null;
        }
        SnacRequest snacRequest = (SnacRequest)this.queue.removeFirst();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Dequeueing " + snacRequest.getCommand() + " from ratequeue (class " + this.rateMonitor.getRateInfo().getRateClass() + ")...");
        }
        return snacRequest;
    }

    synchronized void dequeueAll(Collection collection) {
        collection.addAll(this.queue);
        this.queue.clear();
    }

    synchronized void clear() {
        this.queue.clear();
    }
}

