/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import [Ljava.lang.Object;;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractListDeserializer;
import com.caucho.hessian.io.Deserializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class ArrayDeserializer
extends AbstractListDeserializer {
    private Class _componentType;

    public ArrayDeserializer(Deserializer componentDeserializer) {
        if (componentDeserializer != null) {
            this._componentType = componentDeserializer.getType();
        }
    }

    public Class getType() {
        return Object;.class;
    }

    public Object readList(AbstractHessianInput in, int length) throws IOException {
        if (length >= 0) {
            Object[] data = this.createArray(length);
            in.addRef(data);
            if (this._componentType != null) {
                for (int i = 0; i < data.length; ++i) {
                    data[i] = in.readObject(this._componentType);
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    data[i] = in.readObject();
                }
            }
            in.readListEnd();
            return data;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        in.addRef(list);
        if (this._componentType != null) {
            while (!in.isEnd()) {
                list.add(in.readObject(this._componentType));
            }
        } else {
            while (!in.isEnd()) {
                list.add(in.readObject());
            }
        }
        in.readListEnd();
        Object[] data = this.createArray(list.size());
        for (int i = 0; i < data.length; ++i) {
            data[i] = list.get(i);
        }
        return data;
    }

    protected Object[] createArray(int length) {
        if (this._componentType != null) {
            return (Object[])Array.newInstance(this._componentType, length);
        }
        return new Object[length];
    }

    public String toString() {
        return "ArrayDeserializer[" + this._componentType + "]";
    }
}

