/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.quorum.impl;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.quorum.Quorum;
import com.hazelcast.quorum.QuorumEvent;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.quorum.QuorumFunction;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;

public class QuorumImpl
implements Quorum {
    private final NodeEngineImpl nodeEngine;
    private final String quorumName;
    private final int size;
    private final QuorumConfig config;
    private final InternalEventService eventService;
    private QuorumFunction quorumFunction;
    private volatile QuorumState quorumState = QuorumState.INITIAL;

    public QuorumImpl(QuorumConfig config, NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.eventService = nodeEngine.getEventService();
        this.config = config;
        this.quorumName = config.getName();
        this.size = config.getSize();
        this.initializeQuorumFunction(nodeEngine.getHazelcastInstance());
    }

    void update(Collection<Member> members) {
        QuorumState previousQuorumState = this.quorumState;
        QuorumState newQuorumState = QuorumState.ABSENT;
        try {
            boolean present = this.quorumFunction.apply(members);
            newQuorumState = present ? QuorumState.PRESENT : QuorumState.ABSENT;
        }
        catch (Exception e) {
            ILogger logger = this.nodeEngine.getLogger(QuorumService.class);
            logger.severe("Quorum function of quorum: " + this.quorumName + " failed! Quorum status is set to " + (Object)((Object)newQuorumState), e);
        }
        this.quorumState = newQuorumState;
        if (previousQuorumState != newQuorumState) {
            this.createAndPublishEvent(members, newQuorumState == QuorumState.PRESENT);
        }
    }

    public String getName() {
        return this.quorumName;
    }

    public int getSize() {
        return this.size;
    }

    public QuorumConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isPresent() {
        return this.quorumState == QuorumState.PRESENT;
    }

    private boolean isQuorumNeeded(Operation op) {
        QuorumType type = this.config.getType();
        switch (type) {
            case WRITE: {
                return QuorumImpl.isWriteOperation(op);
            }
            case READ: {
                return QuorumImpl.isReadOperation(op);
            }
            case READ_WRITE: {
                return QuorumImpl.isReadOperation(op) || QuorumImpl.isWriteOperation(op);
            }
        }
        throw new IllegalStateException("Unhandled quorum type: " + (Object)((Object)type));
    }

    private static boolean isReadOperation(Operation op) {
        return op instanceof ReadonlyOperation;
    }

    private static boolean isWriteOperation(Operation op) {
        return op instanceof MutatingOperation;
    }

    void ensureQuorumPresent(Operation op) {
        if (!this.isQuorumNeeded(op)) {
            return;
        }
        if (!this.isPresent()) {
            throw this.newQuorumException();
        }
    }

    private QuorumException newQuorumException() {
        if (this.size == 0) {
            throw new QuorumException("Cluster quorum failed");
        }
        Collection<Member> memberList = this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        throw new QuorumException("Cluster quorum failed, quorum minimum size: " + this.size + ", current size: " + memberList.size());
    }

    private void createAndPublishEvent(Collection<Member> memberList, boolean presence) {
        QuorumEvent quorumEvent = new QuorumEvent(this.nodeEngine.getThisAddress(), this.size, memberList, presence);
        this.eventService.publishEvent("hz:impl:quorumService", this.quorumName, (Object)quorumEvent, quorumEvent.hashCode());
    }

    private void initializeQuorumFunction(HazelcastInstance hazelcastInstance) {
        if (this.config.getQuorumFunctionImplementation() != null) {
            this.quorumFunction = this.config.getQuorumFunctionImplementation();
        } else if (this.config.getQuorumFunctionClassName() != null) {
            try {
                this.quorumFunction = (QuorumFunction)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), this.config.getQuorumFunctionClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (this.quorumFunction == null) {
            this.quorumFunction = new MemberCountQuorumFunction();
        }
        if (this.quorumFunction instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)this.quorumFunction)).setHazelcastInstance(hazelcastInstance);
        }
    }

    public String toString() {
        return "QuorumImpl{quorumName='" + this.quorumName + '\'' + ", isPresent=" + this.isPresent() + ", size=" + this.size + ", config=" + this.config + ", quorumFunction=" + this.quorumFunction + '}';
    }

    private class MemberCountQuorumFunction
    implements QuorumFunction {
        private MemberCountQuorumFunction() {
        }

        @Override
        public boolean apply(Collection<Member> members) {
            return members.size() >= QuorumImpl.this.size;
        }
    }

    private static enum QuorumState {
        INITIAL,
        PRESENT,
        ABSENT;

    }
}

