/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.version.Version;
import java.io.IOException;

abstract class VersionedClusterOperation
extends AbstractClusterOperation
implements Versioned {
    private int memberListVersion;

    VersionedClusterOperation(int memberListVersion) {
        this.memberListVersion = memberListVersion;
    }

    int getMemberListVersion() {
        return this.memberListVersion;
    }

    @Override
    protected final void writeInternal(ObjectDataOutput out) throws IOException {
        this.writeInternalImpl(out);
        if (VersionedClusterOperation.isGreaterOrEqualV39(out.getVersion())) {
            out.writeInt(this.memberListVersion);
        }
    }

    abstract void writeInternalImpl(ObjectDataOutput var1) throws IOException;

    @Override
    protected final void readInternal(ObjectDataInput in) throws IOException {
        this.readInternalImpl(in);
        if (VersionedClusterOperation.isGreaterOrEqualV39(in.getVersion())) {
            this.memberListVersion = in.readInt();
        }
    }

    abstract void readInternalImpl(ObjectDataInput var1) throws IOException;

    static boolean isGreaterOrEqualV39(Version version) {
        return version.isGreaterOrEqual(Versions.V3_9);
    }
}

