/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.network.FireEvent;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.event.SessionEvent;
import org.openymsg.network.event.SessionListener;

public class EventDispatcher
extends Thread {
    private volatile boolean quitFlag = false;
    private static final Log log = LogFactory.getLog(EventDispatcher.class);
    private final List<FireEvent> queue = Collections.synchronizedList(new LinkedList());
    private final Session session;

    public EventDispatcher(String username, Session session) {
        super("jYMSG Event: " + username);
        this.session = session;
    }

    public void kill() {
        this.quitFlag = true;
        this.interrupt();
    }

    public void append(ServiceType type) {
        this.append(null, type);
    }

    public void append(SessionEvent event, ServiceType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null.");
        }
        if (this.quitFlag) {
            throw new IllegalStateException("No new events can be queued, because the dispatcher is being closed.");
        }
        this.queue.add(new FireEvent(event, type));
    }

    public void run() {
        while (!this.quitFlag) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (!this.queue.isEmpty()) {
                FireEvent event = this.queue.remove(0);
                this.runEventNOW(event);
            }
        }
    }

    public void runEventNOW(FireEvent event) {
        if (event == null) {
            return;
        }
        try {
            HashSet<SessionListener> externalSessionListeners = new HashSet<SessionListener>(this.session.getSessionListeners());
            for (SessionListener l : externalSessionListeners) {
                l.dispatch(event);
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)("error during the dispatch of event: " + event), (Throwable)ex);
        }
    }
}

