/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnMessageIterator;
import net.sf.jml.MsnProtocol;
import net.sf.jml.exception.MsnProtocolException;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncomingError
extends MsnIncomingMessage {
    private static final Log logger = LogFactory.getLog(IncomingError.class);
    private boolean isChunkSupported = false;

    public IncomingError(MsnProtocol msnProtocol) {
        super(msnProtocol);
        switch (this.getErrorCode()) {
            case 241: {
                this.isChunkSupported = true;
                break;
            }
            case 508: {
                this.isChunkSupported = true;
            }
        }
    }

    protected boolean isSupportChunkData() {
        return this.isChunkSupported;
    }

    public int getErrorCode() {
        return NumberUtils.stringToInt(this.getCommand());
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnMessageChain msnMessageChain = msnSession.getOutgoingMessageChain();
        int n = this.getErrorCode();
        int n2 = this.getTransactionId();
        if (this.isSupportChunkData() && this.getChunkData() != null) {
            logger.trace((Object)("Error " + n + ": " + new String(this.getChunkData())));
        }
        MsnMessageIterator msnMessageIterator = msnMessageChain.iterator();
        while (msnMessageIterator.hasPrevious()) {
            MsnOutgoingMessage msnOutgoingMessage = (MsnOutgoingMessage)msnMessageIterator.previous();
            if (msnOutgoingMessage.getTransactionId() != n2) continue;
            throw new MsnProtocolException(n, this, msnOutgoingMessage);
        }
    }
}

