/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class InfoScreen
extends InstallerScreen {
    private JTextPane txaInfo;
    private JScrollPane scpInfo;
    private String infoText;

    public InfoScreen(InstallerWizard installerWizard, String string, boolean bl) {
        super(installerWizard);
        this.infoText = string == null ? "" : InfoScreen.sanitizeHTML(string);
        this.initScreen();
        this.btnPrevious.setVisible(bl);
    }

    public void activate() {
        this.txaInfo.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        super.activate();
    }

    protected void setupControls() {
        boolean bl;
        super.setupControls();
        this.txaInfo = new JTextPane();
        String string = this.infoText.toLowerCase();
        boolean bl2 = bl = string.indexOf("<html>") > -1;
        if (bl) {
            this.txaInfo.setEditorKit(new HTMLEditorKit());
        }
        this.txaInfo.setText(this.infoText);
        Font font = UIManager.getFont("TextField.font");
        if (bl) {
            StyleSheet styleSheet = ((HTMLEditorKit)this.txaInfo.getEditorKit()).getStyleSheet();
            styleSheet.addRule("body {font-size : " + font.getSize() + "pt; }");
            styleSheet.addRule("body {font-family :" + font.getFontName() + "; }");
        } else {
            this.txaInfo.setFont(font);
        }
        this.txaInfo.setEditable(false);
        this.scpInfo = new JScrollPane(this.txaInfo);
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.txaInfo.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIHelper.showURL(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(this.messages.getString("InfoBeforeClickLabel"), jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 10;
        jPanel.add((Component)this.scpInfo, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    protected boolean needsSpacer() {
        return false;
    }

    protected String getTitle() {
        return this.messages.getString("WizardInfoBefore");
    }

    protected String getSubTitle() {
        return this.messages.getString("InfoBeforeLabel");
    }
}

