/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.convert.BeanConverter;
import uk.ltd.getahead.dwr.util.Logger;

public class HibernateBeanConverter
extends BeanConverter {
    private static Map methods = new HashMap();
    private static final String CLASS_HIBERNATE2 = "net.sf.hibernate.Hibernate";
    private static final String CLASS_HIBERNATE3 = "org.hibernate.Hibernate";
    private Class hibernate;
    private Method getClass;
    private Method isPropertyInitialized;
    private Method isInitialized;
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.convert.HibernateBeanConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public HibernateBeanConverter() throws ClassNotFoundException {
        try {
            this.hibernate = Class.forName(CLASS_HIBERNATE3);
            log.info("Found Hibernate3 class: " + this.hibernate.getName());
        }
        catch (Exception ex) {
            try {
                this.hibernate = Class.forName(CLASS_HIBERNATE2);
                log.info("Found Hibernate2 class: " + this.hibernate.getName());
            }
            catch (Exception ex2) {
                throw new ClassNotFoundException(Messages.getString("HibernateBeanConverter.MissingClass"));
            }
        }
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            this.getClass = this.hibernate.getMethod("getClass", classArray);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(Messages.getString("HibernateBeanConverter.MissingGetClass"));
        }
        try {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            this.isPropertyInitialized = this.hibernate.getMethod("isPropertyInitialized", classArray);
        }
        catch (Exception ex) {
            log.info("Hibernate.isPropertyInitialized() is not available in Hibernate2 so initialization checks will not take place");
        }
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            this.isInitialized = this.hibernate.getMethod("isInitialized", classArray);
        }
        catch (Exception ex) {
            log.info("Hibernate.isInitialized() is not available - verify you have the Hibernate jar on your classpath");
        }
    }

    protected BeanInfo getBeanInfo(Object bean) throws IntrospectionException {
        try {
            Class clazz = (Class)this.getClass.invoke(null, bean);
            BeanInfo info = Introspector.getBeanInfo(clazz);
            return info;
        }
        catch (IntrospectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("Logic Error", ex);
            throw new IntrospectionException(ex.getMessage());
        }
    }

    public boolean isAvailable(Object data, String property) {
        try {
            if (this.isPropertyInitialized != null) {
                boolean inited;
                PropertyDescriptor[] props = Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors();
                String key = String.valueOf(data.getClass().getName()) + property;
                Method method = (Method)methods.get(key);
                if (method == null) {
                    int i = 0;
                    while (i < props.length) {
                        if (props[i].getName().equalsIgnoreCase(property)) {
                            method = props[i].getReadMethod();
                        }
                        ++i;
                    }
                    methods.put(key, method);
                }
                Boolean reply = (Boolean)this.isPropertyInitialized.invoke(null, data, property);
                Boolean reply2 = (Boolean)this.isInitialized.invoke(null, method.invoke(data, new Object[0]));
                boolean bl = inited = reply != false && reply2 != false;
                if (!inited) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.error("Failed in checking Hibernate the availability of " + property, ex);
            return false;
        }
    }
}

